/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

public abstract class AbstractLobCreatingPreparedStatementCallback
implements PreparedStatementCallback {
    private final LobHandler lobHandler;

    public AbstractLobCreatingPreparedStatementCallback(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        try {
            this.setValues(ps, lobCreator);
            Integer n = new Integer(ps.executeUpdate());
            return n;
        }
        finally {
            lobCreator.close();
        }
    }

    protected abstract void setValues(PreparedStatement var1, LobCreator var2) throws SQLException, DataAccessException;
}

