/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.SetUpMenuBar;

public class LocalTreeToolBar
extends JToolBar {
    public LocalTreeToolBar(final JembossParams jembossParams) {
        Dimension dimension = new Dimension(22, 24);
        JButton jButton = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(new Color(0, 128, 0));
                float[][] fArrayArray = new float[][]{{11.0f, 18.0f}, {7.0f, 18.0f}, {7.0f, 14.0f}, {3.0f, 14.0f}, {11.0f, 4.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray));
                graphics2D.setColor(Color.green);
                float[][] fArrayArray2 = new float[][]{{11.0f, 18.0f}, {15.0f, 18.0f}, {15.0f, 14.0f}, {19.0f, 14.0f}, {11.0f, 4.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray2));
                this.setSize(22, 24);
            }
        };
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setToolTipText("Move Up a Directory");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(jembossParams.getUserHome());
                LocalTreeToolBar.this.setDirectory(file.getParentFile(), jembossParams);
            }
        });
        this.add(jButton);
        JButton jButton2 = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Font font = new Font("Monospaced", 1, 14);
                graphics2D.setFont(font);
                graphics2D.setColor(Color.black);
                graphics2D.drawString("W", 4, 18);
                graphics2D.setColor(Color.red);
                graphics2D.drawString("D", 10, 15);
                this.setSize(22, 24);
            }
        };
        jButton2.setPreferredSize(dimension);
        jButton2.setMaximumSize(dimension);
        jButton2.setToolTipText("Move To Working Directory");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(System.getProperty("user.dir"));
                LocalTreeToolBar.this.setDirectory(file, jembossParams);
            }
        });
        this.add(jButton2);
        JButton jButton3 = new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.blue);
                float[][] fArrayArray = new float[][]{{3.0f, 14.0f}, {11.0f, 3.0f}, {19.0f, 14.0f}, {17.0f, 14.0f}, {17.0f, 18.0f}, {5.0f, 18.0f}, {5.0f, 14.0f}};
                graphics2D.fill(Browser.makeShape(fArrayArray));
                this.setSize(22, 24);
            }
        };
        jButton3.setPreferredSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton3.setToolTipText("Move To Home Directory");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(jembossParams.getUserHome());
                LocalTreeToolBar.this.setDirectory(file, jembossParams);
            }
        });
        this.add(jButton3);
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 34));
    }

    private void setDirectory(File file, JembossParams jembossParams) {
        if (file.exists() && file.canRead()) {
            String string = file.getAbsolutePath();
            Jemboss.tree.newRoot(string);
            if (SetUpMenuBar.localAndRemoteTree != null) {
                SetUpMenuBar.localAndRemoteTree.getLocalDragTree().newRoot(string);
            }
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(null, "You cannot write to this directory.", "Warning: Write", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No access to this directory.", "Error: Access", 0);
        }
    }
}

