/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.constant.Constable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.draw.EmbossCirdnaReader;
import org.emboss.jemboss.draw.GeneticMarker;
import org.emboss.jemboss.draw.LineAttribute;
import org.emboss.jemboss.draw.RestrictionEnzyme;
import org.emboss.jemboss.draw.Ticks;
import org.emboss.jemboss.gui.ScrollPanel;

public class Wizard {
    private DNADraw dna = null;

    public Wizard(DNADraw dNADraw) {
        int n = this.getOption(dNADraw);
        if (n == 0) {
            Vector vector = new Vector();
            EmbossCirdnaReader embossCirdnaReader = new EmbossCirdnaReader();
            Hashtable<String, Constable> hashtable = new Hashtable<String, Constable>();
            hashtable.put("lsize", new Integer(5));
            hashtable.put("circular", new Boolean(true));
            hashtable.put("start", new Integer(embossCirdnaReader.getStart()));
            hashtable.put("end", new Integer(embossCirdnaReader.getEnd()));
            this.dna = new DNADraw(embossCirdnaReader.getBlock(), embossCirdnaReader.getRestrictionEnzyme(), hashtable, 0, 100, 100);
        } else if (n == 1 || n == 2) {
            int n2;
            JFrame jFrame = new JFrame("Genetic Feature");
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            if (dNADraw == null) {
                this.dna = new DNADraw();
            } else {
                this.dna = dNADraw;
                vector = dNADraw.getGeneticMarker();
                vector2 = dNADraw.getRestrictionEnzyme();
            }
            LineAttribute lineAttribute = new LineAttribute(this.dna);
            GeneticMarker geneticMarker = dNADraw != null ? new GeneticMarker(dNADraw, vector) : new GeneticMarker(this.dna, vector);
            RestrictionEnzyme restrictionEnzyme = dNADraw != null ? new RestrictionEnzyme(dNADraw, vector2) : new RestrictionEnzyme(this.dna, vector2);
            Ticks ticks = new Ticks(dNADraw, false);
            lineAttribute.setMinimumSize(lineAttribute.getPreferredSize());
            lineAttribute.setMaximumSize(lineAttribute.getPreferredSize());
            restrictionEnzyme.setMinimumSize(restrictionEnzyme.getPreferredSize());
            restrictionEnzyme.setMaximumSize(restrictionEnzyme.getPreferredSize());
            ScrollPanel scrollPanel = new ScrollPanel(new BorderLayout());
            Box box = Box.createVerticalBox();
            box.add(new JLabel("DNA Attributes"));
            Box box2 = Box.createHorizontalBox();
            box2.add(lineAttribute);
            box2.add(ticks);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            box.add(Box.createHorizontalStrut(10));
            box.add(new JLabel("Genetic Feature"));
            box2 = Box.createHorizontalBox();
            box2.add(geneticMarker);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            box.add(Box.createHorizontalStrut(10));
            box.add(new JLabel("Restriction Enzymes"));
            box2 = Box.createHorizontalBox();
            box2.add(restrictionEnzyme);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            scrollPanel.add((Component)box, "Center");
            JScrollPane jScrollPane = new JScrollPane(scrollPanel);
            Dimension dimension = jFrame.getToolkit().getScreenSize();
            int n3 = (int)dimension.getWidth();
            if (n3 > 700) {
                n3 = 700;
            }
            if ((n2 = (int)dimension.getHeight()) > 750) {
                n2 = 700;
            }
            Dimension dimension2 = new Dimension(n3, n2 -= 50);
            jScrollPane.setPreferredSize(dimension2);
            JOptionPane.showMessageDialog(null, jScrollPane, "DNA Wizard", -1);
            this.dna.setGeneticMarker(vector);
            this.dna.setRestrictionEnzyme(vector2);
            this.dna.setLineAttributes(lineAttribute.getLineAttr());
            this.dna.setStartTick(ticks.getStartTick());
            this.dna.setMinorTickInterval(ticks.getMinorTickInterval());
            this.dna.setTickInterval(ticks.getTickInterval());
            int n4 = lineAttribute.getStart();
            this.dna.setStart(n4);
            n4 = lineAttribute.getEnd();
            this.dna.setEnd(n4);
        }
    }

    public DNADraw getDNADraw() {
        return this.dna;
    }

    private int getOption(DNADraw dNADraw) {
        Box box = Box.createVerticalBox();
        JRadioButton[] jRadioButtonArray = dNADraw != null ? new JRadioButton[3] : new JRadioButton[2];
        ButtonGroup buttonGroup = new ButtonGroup();
        jRadioButtonArray[0] = new JRadioButton("Read in data file");
        buttonGroup.add(jRadioButtonArray[0]);
        jRadioButtonArray[1] = new JRadioButton("Create new dna display");
        buttonGroup.add(jRadioButtonArray[1]);
        jRadioButtonArray[1].setSelected(true);
        box.add(jRadioButtonArray[0]);
        box.add(jRadioButtonArray[1]);
        if (dNADraw != null) {
            jRadioButtonArray[2] = new JRadioButton("Edit current dna display");
            buttonGroup.add(jRadioButtonArray[2]);
            jRadioButtonArray[2].setSelected(true);
            box.add(jRadioButtonArray[2]);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(box);
        JOptionPane.showMessageDialog(null, jPanel, "Jemboss DNA Viewer Wizard", 3);
        if (jRadioButtonArray[0].isSelected()) {
            return 0;
        }
        if (jRadioButtonArray[1].isSelected()) {
            return 1;
        }
        if (jRadioButtonArray[2].isSelected()) {
            return 2;
        }
        return 1;
    }
}

