/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.logging.Logger;

public class Name {
    private static final Logger logger = Logger.getLogger(Name.class.toString());
    private static final int HEX_CHAR = 35;
    private String name;

    public Name(String name) {
        if (name != null) {
            this.name = this.convertHexChars(new StringBuilder(name));
        }
    }

    public Name(StringBuilder name) {
        this.name = this.convertHexChars(name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Name) {
            return this.name.equals(((Name)obj).getName());
        }
        return obj instanceof String && this.name.equals(obj);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private String convertHexChars(StringBuilder name) {
        try {
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) != '#') continue;
                int charDd = Integer.parseInt(name.substring(i + 1, i + 3), 16);
                name.delete(i, i + 3);
                name.insert(i, (char)charDd);
            }
        }
        catch (Throwable e) {
            logger.warning("Error parsing hexadecimal characters.");
            return name.toString();
        }
        return name.toString();
    }
}

