/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDeadLetterStrategy
implements DeadLetterStrategy {
    private static final Log LOG = LogFactory.getLog(AbstractDeadLetterStrategy.class);
    private boolean processNonPersistent = false;
    private boolean processExpired = true;
    private ActiveMQMessageAudit audit = new ActiveMQMessageAudit();

    public boolean isSendToDeadLetterQueue(Message message) {
        boolean result = false;
        if (message != null) {
            result = true;
            if (this.audit.isDuplicate(message)) {
                result = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not adding duplicate to DLQ: " + message.getMessageId() + ", dest: " + message.getDestination());
                }
            }
            if (!message.isPersistent() && !this.processNonPersistent) {
                result = false;
            }
            if (message.isExpired() && !this.processExpired) {
                result = false;
            }
        }
        return result;
    }

    public boolean isProcessExpired() {
        return this.processExpired;
    }

    public void setProcessExpired(boolean processExpired) {
        this.processExpired = processExpired;
    }

    public boolean isProcessNonPersistent() {
        return this.processNonPersistent;
    }

    public void setProcessNonPersistent(boolean processNonPersistent) {
        this.processNonPersistent = processNonPersistent;
    }
}

