/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.som;

import java.awt.Color;
import java.io.Serializable;

public class SOMDataItem
implements Cloneable,
Serializable {
    private Color color;
    private String[] descriptions;
    private double[] neuronWeights;
    private boolean selected;

    public SOMDataItem(Color color, String[] descriptions, double[] neuronWeights) throws NullPointerException {
        if (color == null || descriptions == null || neuronWeights == null) {
            throw new NullPointerException("color/descriptions/neuronWeights given to SOMDataItem was null.");
        }
        if (descriptions.length == 0) {
            throw new IllegalArgumentException("descriptions given to SOMDataItem did not contain any strings.");
        }
        if (neuronWeights.length == 0) {
            throw new IllegalArgumentException("neuronWeights given to SOMDataItem did not contain any values.");
        }
        this.color = color;
        this.descriptions = descriptions;
        this.neuronWeights = neuronWeights;
        this.selected = false;
    }

    public Color getColor() {
        return this.color;
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public double[] getNeuronWeights() {
        return this.neuronWeights;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException("color given to setColor() was null.");
        }
        this.color = color;
    }

    public void setDescriptions(String[] descriptions) {
        if (descriptions == null) {
            throw new NullPointerException("descriptions given to setDescriptions() was null.");
        }
        this.descriptions = descriptions;
    }

    public void setNeuronWeights(double[] neuronWeights) {
        if (neuronWeights == null) {
            throw new NullPointerException("neuronWeights given to setNeuronWeights() was null.");
        }
        this.neuronWeights = neuronWeights;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SOMDataItem)) {
            return false;
        }
        SOMDataItem that = (SOMDataItem)obj;
        if (!this.color.equals(that.color)) {
            return false;
        }
        if (this.selected != that.selected) {
            return false;
        }
        if (this.descriptions.length != that.descriptions.length) {
            return false;
        }
        for (i = 0; i < this.descriptions.length; ++i) {
            if (this.descriptions[i] == null && that.descriptions[i] == null || this.descriptions[i] != null && that.descriptions[i] != null && this.descriptions[i].equals(that.descriptions[i])) continue;
            return false;
        }
        if (this.neuronWeights.length != that.neuronWeights.length) {
            return false;
        }
        for (i = 0; i < this.neuronWeights.length; ++i) {
            if (this.neuronWeights[i] == that.neuronWeights[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        SOMDataItem clone = (SOMDataItem)super.clone();
        clone.descriptions = (String[])this.descriptions.clone();
        clone.neuronWeights = (double[])this.neuronWeights.clone();
        return clone;
    }
}

