/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientColorPalette
implements Cloneable {
    private TreeMap<Double, Color> keyColorMap = new TreeMap();
    private boolean linearMapping = true;
    private LinkedList<ChangeListener> listeners = new LinkedList();
    private double minLinearValue;
    private double maxLinearValue;
    private boolean logarithmOverZero;
    private final double NEGATIVE_ZERO = -0.01;
    private boolean logarithmBelowZero;

    public GradientColorPalette(double[] minMaxValues, Color[] minMaxMidColors) {
        this.setKeyColors(minMaxValues, minMaxMidColors);
    }

    public Color setKeyColor(double value, Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color old = this.keyColorMap.remove(new Double(value));
        this.keyColorMap.put(new Double(value), color);
        this.notifyChangeListeners(new ChangeEvent(this));
        return old;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyChangeListeners(ChangeEvent event) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public Color getKeyColor(double value) {
        return this.keyColorMap.get(new Double(value));
    }

    private double log(double value) {
        boolean isNegative = false;
        if (value == 0.0) {
            double d = value = this.logarithmBelowZero ? -0.01 : 0.01;
        }
        if (value < 0.0) {
            isNegative = true;
            value = Math.abs(value);
        }
        if (this.logarithmOverZero) {
            value += 1.0;
        }
        value = Math.log(value);
        if (isNegative) {
            value = -value;
        }
        return value;
    }

    public Color getColor(double value) {
        double proportion;
        Double value2;
        Double value1;
        Double valueObject;
        Color color;
        if (!this.linearMapping) {
            value = this.log(value);
        }
        if ((color = this.keyColorMap.get(valueObject = new Double(value))) != null) {
            return color;
        }
        try {
            value1 = this.keyColorMap.headMap(valueObject).lastKey();
        }
        catch (NoSuchElementException e) {
            return this.keyColorMap.get(this.keyColorMap.tailMap(valueObject).firstKey());
        }
        try {
            value2 = this.keyColorMap.tailMap(valueObject).firstKey();
        }
        catch (NoSuchElementException e) {
            return this.keyColorMap.get(this.keyColorMap.headMap(valueObject).lastKey());
        }
        Color color1 = this.keyColorMap.get(value1);
        Color color2 = this.keyColorMap.get(value2);
        if (this.linearMapping) {
            proportion = (value - value1) / (value2 - value1);
        } else {
            if (value < 0.0) {
                value = Math.abs(value);
                value1 = Math.abs(value1);
                value2 = Math.abs(value2);
                Color tmpC = color1;
                color1 = color2;
                color2 = tmpC;
                double tmpV = value1;
                value1 = value2;
                value2 = tmpV;
            }
            proportion = (value - value1) / (value2 - value1);
        }
        return new Color((int)((double)color2.getRed() * proportion + (double)color1.getRed() * (1.0 - proportion)), (int)((double)color2.getGreen() * proportion + (double)color1.getGreen() * (1.0 - proportion)), (int)((double)color2.getBlue() * proportion + (double)color1.getBlue() * (1.0 - proportion)));
    }

    public void setLinear(boolean linear) {
        this.linearMapping = linear;
        Iterator<Color> colors = new ArrayList<Color>(this.keyColorMap.values()).iterator();
        this.keyColorMap.clear();
        double[] values = this.getKeyValues();
        this.keyColorMap.put(values[Keys.MIN.ordinal()], colors.next());
        this.keyColorMap.put(values[Keys.MID.ordinal()], colors.next());
        this.keyColorMap.put(values[Keys.MAX.ordinal()], colors.next());
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    public double[] getKeyValues() {
        double[] values = new double[3];
        if (this.linearMapping) {
            values[Keys.MIN.ordinal()] = this.minLinearValue;
            values[Keys.MID.ordinal()] = (this.maxLinearValue + this.minLinearValue) / 2.0;
            values[Keys.MAX.ordinal()] = this.maxLinearValue;
        } else {
            if (this.maxLinearValue == 0.0 || this.maxLinearValue == -0.01) {
                this.logarithmBelowZero = true;
                this.maxLinearValue = -0.01;
            } else {
                this.logarithmBelowZero = false;
            }
            values[Keys.MIN.ordinal()] = this.log(this.minLinearValue);
            values[Keys.MAX.ordinal()] = this.log(this.maxLinearValue);
            if (this.minLinearValue < 0.0 && this.maxLinearValue > 0.0) {
                this.logarithmOverZero = true;
                values[Keys.MID.ordinal()] = 0.0;
            } else {
                this.logarithmOverZero = false;
                values[Keys.MID.ordinal()] = (values[Keys.MIN.ordinal()] + values[Keys.MAX.ordinal()]) / 2.0;
            }
        }
        return values;
    }

    public double[] getOriginalMinMaxValues() {
        double[] values = new double[]{this.minLinearValue, this.maxLinearValue};
        return values;
    }

    public boolean isLinear() {
        return this.linearMapping;
    }

    public void setKeyColors(double[] minMaxValues, Color[] minMaxMidColors) {
        this.minLinearValue = minMaxValues[0];
        this.maxLinearValue = minMaxValues[1];
        this.keyColorMap.put(0.0, minMaxMidColors[Keys.MIN.ordinal()]);
        this.keyColorMap.put(1.0, minMaxMidColors[Keys.MID.ordinal()]);
        this.keyColorMap.put(2.0, minMaxMidColors[Keys.MAX.ordinal()]);
        this.setLinear(this.linearMapping);
    }

    public Color[] getKeyColors() {
        Object[] keys = this.keyColorMap.keySet().toArray(new Double[0]);
        Arrays.sort(keys);
        return new Color[]{this.keyColorMap.get(keys[0]), this.keyColorMap.get(keys[1]), this.keyColorMap.get(keys[2])};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        MIN,
        MID,
        MAX;

    }
}

