/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;

public class MultiChartUtilities {
    public static void saveChartsAsPNG(File file, List charts, int width, int height) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (charts == null) {
            throw new IllegalArgumentException("Null 'charts' argument.");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        MultiChartUtilities.writeChartsAsPNG(out, charts, width, height);
        ((OutputStream)out).close();
    }

    public static void writeChartsAsPNG(OutputStream out, List charts, int width, int height) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (charts == null) {
            throw new IllegalArgumentException("Null 'charts' argument.");
        }
        Iterator i = charts.iterator();
        int saveColumns = 2;
        int saveRows = new BigDecimal((double)charts.size()).divide(new BigDecimal((double)saveColumns), 0).intValue();
        BufferedImage picture = new BufferedImage(width * saveColumns, height * saveRows, 2);
        Graphics2D g2 = picture.createGraphics();
        int x = 0;
        int y = 0;
        while (i.hasNext()) {
            for (int j = 0; j < saveColumns; ++j) {
                if (!i.hasNext()) continue;
                BufferedImage chartImage = ((JFreeChart)i.next()).createBufferedImage(width, height);
                g2.drawImage(chartImage, null, x, y);
                x += width;
            }
            x = 0;
            y += height;
        }
        g2.dispose();
        EncoderUtil.writeBufferedImage((BufferedImage)picture, (String)"png", (OutputStream)out);
    }

    public static void saveChartsAsJPEG(File file, List charts, int width, int height) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (charts == null) {
            throw new IllegalArgumentException("Null 'charts' argument.");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        MultiChartUtilities.writeChartsAsJPEG(out, charts, width, height);
        ((OutputStream)out).close();
    }

    public static void writeChartsAsJPEG(OutputStream out, List charts, int width, int height) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (charts == null) {
            throw new IllegalArgumentException("Null 'charts' argument.");
        }
        Iterator i = charts.iterator();
        int saveColumns = 2;
        int saveRows = new BigDecimal((double)charts.size()).divide(new BigDecimal((double)saveColumns), 0).intValue();
        BufferedImage picture = new BufferedImage(width * saveColumns, height * saveRows, 2);
        Graphics2D g2 = picture.createGraphics();
        int x = 0;
        int y = 0;
        while (i.hasNext()) {
            for (int j = 0; j < saveColumns; ++j) {
                if (!i.hasNext()) continue;
                BufferedImage chartImage = ((JFreeChart)i.next()).createBufferedImage(width, height);
                g2.drawImage(chartImage, null, x, y);
                x += width;
            }
            x = 0;
            y += height;
        }
        g2.dispose();
        EncoderUtil.writeBufferedImage((BufferedImage)picture, (String)"jpeg", (OutputStream)out);
    }
}

