/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker.encryption;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class TestServer {
    public static void main(String[] args) throws Exception {
        Server jettyInstance = new Server();
        jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setServer(jettyInstance);
        connector.setPort(9080);
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setServer(jettyInstance);
        sslConnector.setPort(9443);
        sslConnector.setKeystore("keystore.ks");
        sslConnector.setKeyPassword("microarray");
        jettyInstance.setConnectors(new Connector[]{connector, sslConnector});
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)jettyInstance, "/", false, false);
        root.setResourceBase("/tmp/test-root");
        root.addServlet(new ServletHolder((Servlet)new UploadServlet()), "/*");
        jettyInstance.start();
    }

    public static class UploadServlet
    extends DefaultServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            System.out.println("GET request for " + request.getRequestURL());
            super.doGet(request, response);
        }

        protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            boolean success;
            System.out.println("PUT request for " + request.getRequestURL());
            File file = new File(this.getServletContext().getRealPath(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())));
            if (file.exists() && !(success = file.delete())) {
                response.sendError(500);
                return;
            }
            FileOutputStream out = new FileOutputStream(file);
            try {
                IO.copy((InputStream)request.getInputStream(), (OutputStream)out);
            }
            catch (IOException e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
                out.close();
                throw e;
            }
            response.setStatus(204);
        }
    }
}

