/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import java.util.Iterator;

public class CalculatingIterable
implements Iterable<Float> {
    private Iterable<Float> f1;
    private Iterable<Float> f2;
    private CalcOperation operation;

    public CalculatingIterable(Iterable<Float> f1, Iterable<Float> f2, CalcOperation operation) {
        this.f1 = f1;
        this.f2 = f2;
        this.operation = operation;
    }

    @Override
    public Iterator<Float> iterator() {
        Iterator<Float> iterator1 = this.f1.iterator();
        Iterator<Float> iterator2 = this.f2 != null ? this.f2.iterator() : null;
        return new CalculatingIterator(iterator1, iterator2, this.operation);
    }

    public static class CalculatingIterator
    implements Iterator<Float> {
        private CalcOperation operation;
        private Iterator<Float> f1;
        private Iterator<Float> f2;

        public CalculatingIterator(Iterator<Float> iterator, Iterator<Float> iterator2, CalcOperation operation) {
            this.f1 = iterator;
            this.f2 = iterator2;
            this.operation = operation;
        }

        @Override
        public boolean hasNext() {
            return this.f1.hasNext() && (this.f2 == null || this.f2.hasNext());
        }

        @Override
        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public float nextFloat() {
            float r;
            switch (this.operation) {
                case ADD: {
                    r = this.f1.next().floatValue() + this.f2.next().floatValue();
                    break;
                }
                case SUBTRACT: {
                    r = this.f1.next().floatValue() - this.f2.next().floatValue();
                    break;
                }
                case MULTIPLY: {
                    r = this.f1.next().floatValue() * this.f2.next().floatValue();
                    break;
                }
                case DIVIDE: {
                    r = this.f1.next().floatValue() / this.f2.next().floatValue();
                    break;
                }
                case LOG_2: {
                    r = (float)(Math.log(this.f1.next().floatValue()) / Math.log(2.0));
                    break;
                }
                case NEGATE: {
                    r = -this.f1.next().floatValue();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown operation " + (Object)((Object)this.operation));
                }
            }
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum CalcOperation {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        LOG_2,
        NEGATE;

    }
}

