/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import java.util.Arrays;

public class Matrix {
    public double[][] array;

    public Matrix(int m, int n) {
        this.array = new double[m][n];
    }

    public Matrix(int m, int n, double v) {
        this(m, n);
        for (int i = 0; i < this.array.length; ++i) {
            Arrays.fill(this.array[i], v);
        }
    }

    public void set(int m, int n, double v) {
        this.array[m][n] = v;
    }

    public double get(int m, int n) {
        return this.array[m][n];
    }

    public Matrix times(Matrix that) {
        if (this.array[0].length != that.array.length) {
            throw new IllegalArgumentException("Matrix dimension do not allow multiplication.");
        }
        int m = this.array.length;
        int n = this.array[0].length;
        int a = that.array[0].length;
        double[] tmp = new double[n];
        Matrix r = new Matrix(m, a);
        for (int j = 0; j < a; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                tmp[i] = that.array[i][j];
            }
            for (i = 0; i < m; ++i) {
                r.array[i][j] = this.times(this.array[i], tmp);
            }
        }
        return r;
    }

    private double times(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }
}

