/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class SeparatorTrack3D
extends SeparatorTrack {
    private boolean reversed;
    private static LinkedList<Color> colorSlide = new LinkedList();
    private static LinkedList<Color> reversedColorSlide = new LinkedList();

    public SeparatorTrack3D(View view, long minBpLength, long maxBpLength, boolean reversed) {
        super(view, minBpLength, maxBpLength);
        this.reversed = reversed;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        LinkedList<Color> slide = this.reversed ? reversedColorSlide : colorSlide;
        for (int i = 0; i < slide.size(); ++i) {
            drawables.add(new LineDrawable(0, i, this.getView().getWidth(), i, slide.get(i)));
        }
        return drawables;
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return colorSlide.size();
        }
        return 0;
    }

    static {
        Color[] colors = new Color[]{new Color(243, 243, 243), new Color(224, 224, 224), new Color(176, 176, 176), new Color(64, 64, 64)};
        colorSlide.addAll(Arrays.asList(colors));
        reversedColorSlide.addAll(Arrays.asList(colors));
        Collections.reverse(reversedColorSlide);
    }
}

