/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.CytobandDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Cytoband;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CytobandTrack
extends Track {
    private static final int THICKNESS = 11;
    private static final int MARGIN = 2;
    private SortedSet<Cytoband> cbands = new TreeSet<Cytoband>();
    private boolean showText;
    final Map<Cytoband.Stain, Color> stainColors = new HashMap<Cytoband.Stain, Color>();

    public CytobandTrack(View view, CytobandDataSource data, boolean showText) {
        super(view, data);
        this.stainColors.put(Cytoband.Stain.GNEG, Color.white);
        this.stainColors.put(Cytoband.Stain.GPOS25, Color.lightGray);
        this.stainColors.put(Cytoband.Stain.GPOS33, Color.lightGray);
        this.stainColors.put(Cytoband.Stain.GPOS50, Color.gray);
        this.stainColors.put(Cytoband.Stain.GPOS66, Color.darkGray);
        this.stainColors.put(Cytoband.Stain.GPOS75, Color.darkGray);
        this.stainColors.put(Cytoband.Stain.GPOS100, Color.black);
        this.stainColors.put(Cytoband.Stain.GPOS, Color.black);
        this.stainColors.put(Cytoband.Stain.ACEN, null);
        this.stainColors.put(Cytoband.Stain.GVAR, Color.lightGray);
        this.stainColors.put(Cytoband.Stain.STALK, null);
        this.stainColors.put(Cytoband.Stain.TIP, Color.black);
        this.stainColors.put(Cytoband.Stain.UNRECOGNIZED, null);
        this.showText = showText;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.cbands != null) {
            boolean firstGap = true;
            Iterator cbandIter = this.cbands.iterator();
            while (cbandIter.hasNext()) {
                Cytoband cband = (Cytoband)cbandIter.next();
                if (!this.getView().getBpRegion().intersects(cband.getRegion())) {
                    cbandIter.remove();
                    continue;
                }
                Cytoband.Stain stain = cband.getStain();
                Color stainColor = this.stainColors.get((Object)stain);
                String text = cband.getBand();
                if (text == null) {
                    text = "";
                }
                if (stain != null && stainColor != null) {
                    RectDrawable box = this.createDrawable(cband.getRegion().start, cband.getRegion().end, stainColor);
                    drawables.add(box);
                    if (this.showText) {
                        int CHAR_WIDTH = 7;
                        int textSpace = 0;
                        textSpace = box.x >= 0 ? box.width : box.width + box.x;
                        if (textSpace > text.length() * 7) {
                            int textX = Math.max(0, box.x);
                            drawables.add(new TextDrawable(textX, box.y - 2, text, Color.black));
                        }
                    }
                    firstGap = true;
                    continue;
                }
                if (stain == Cytoband.Stain.ACEN) {
                    int y = 2;
                    int sideX = this.getView().bpToTrack(cband.getRegion().end);
                    int cornerX = this.getView().bpToTrack(cband.getRegion().start);
                    if (firstGap) {
                        int tmp = sideX;
                        sideX = cornerX;
                        cornerX = tmp;
                        firstGap = false;
                    }
                    drawables.add(new LineDrawable(sideX, y, cornerX, y + 5, Color.black));
                    drawables.add(new LineDrawable(sideX, y + 11 - 1, cornerX, y + 5, Color.black));
                    continue;
                }
                if (stain != Cytoband.Stain.STALK) continue;
                Rectangle rect = new Rectangle();
                rect.x = this.getView().bpToTrack(cband.getRegion().start);
                rect.width = this.getView().bpToTrack(cband.getRegion().end) - rect.x;
                rect.y = 4;
                rect.height = 6;
                drawables.add(new RectDrawable(rect, Color.gray, Color.gray));
            }
        }
        return drawables;
    }

    private RectDrawable createDrawable(BpCoord startBp, BpCoord endBp, Color c) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp) - 1;
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        rect.y = 2;
        rect.height = 11;
        return new RectDrawable(rect, c, Color.black);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (!this.getView().getBpRegion().intersects(content.region)) continue;
            Cytoband cband = (Cytoband)content.values.get((Object)ColumnType.VALUE);
            this.cbands.add(cband);
        }
        this.getView().redraw();
    }

    @Override
    public Integer getHeight() {
        return this.showText ? 40 : 20;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.VALUE)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public String getName() {
        return "cytoband";
    }
}

