/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class TabixHandlerThread
extends AreaRequestHandler {
    protected TabixDataSource dataSource;
    protected BlockingQueue<BpCoordFileRequest> fileRequestQueue = new LinkedBlockingQueue<BpCoordFileRequest>();
    protected ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue = new ConcurrentLinkedQueue();

    public TabixHandlerThread(DataSource file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.dataSource = (TabixDataSource)file;
    }

    @Override
    protected boolean checkOtherQueues() {
        ParsedFileResult fileResult = null;
        fileResult = this.fileResultQueue.poll();
        if (fileResult != null) {
            this.processFileResult(fileResult);
        }
        return fileResult != null;
    }

    protected void processFileResult(ParsedFileResult fileResult) {
        this.createAreaResult(new AreaResult(fileResult.getStatus(), fileResult.getContents()));
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        super.processAreaRequest(areaRequest);
        if (areaRequest.status.poison) {
            BpCoordFileRequest fileRequest = new BpCoordFileRequest(areaRequest, null, null, areaRequest.status);
            this.fileRequestQueue.add(fileRequest);
            return;
        }
        this.fileRequestQueue.add(new BpCoordFileRequest(areaRequest, areaRequest.start, areaRequest.end, areaRequest.status));
    }
}

