/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkTreeHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ByteRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ChunkFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ChunkFileResult;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ChunkFileFetcherThread
extends Thread {
    private BlockingQueue<ChunkFileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<ChunkFileResult> fileResultQueue;
    private ChunkTreeHandlerThread areaRequestThread;
    private ChunkDataSource dataSource;
    private FileParser inputParser;
    private boolean poison = false;

    public ChunkFileFetcherThread(BlockingQueue<ChunkFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ChunkFileResult> fileResultQueue, ChunkTreeHandlerThread areaRequestThread, FileParser inputParser) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.inputParser = inputParser;
        this.setDaemon(true);
        this.dataSource = areaRequestThread.getFile();
    }

    @Override
    public void run() {
        while (!this.poison) {
            try {
                for (ChunkFileRequest fileRequest : this.fileRequestQueue) {
                    if (!fileRequest.status.poison) continue;
                    this.poison = true;
                }
                this.processFileRequest(this.fileRequestQueue.take());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.dataSource.close();
    }

    private void processFileRequest(ChunkFileRequest fileRequest) throws IOException {
        byte[] byteChunk;
        if (fileRequest.status.poison) {
            this.poison = true;
            return;
        }
        Chunk chunk = new Chunk();
        ByteRegion exactRegion = null;
        if (fileRequest.byteRegion.exact) {
            byteChunk = new byte[(int)fileRequest.byteRegion.getLength()];
            this.dataSource.read(fileRequest.byteRegion.start, byteChunk);
            chunk.setContent(new String(byteChunk));
        } else {
            int i;
            String file;
            block9: {
                byteChunk = new byte[(int)fileRequest.byteRegion.getLength() + 1000];
                int length = this.dataSource.read(fileRequest.byteRegion.start, byteChunk);
                file = new String(byteChunk).substring(0, length);
                exactRegion = new ByteRegion();
                i = 0;
                if (fileRequest.byteRegion.start != 0L) {
                    while (true) {
                        if (i >= file.length()) {
                            return;
                        }
                        if (file.charAt(i) == '\n') {
                            exactRegion.start = fileRequest.byteRegion.start + (long)(++i);
                            break block9;
                        }
                        ++i;
                    }
                }
                exactRegion.start = 0L;
            }
            StringBuffer lines = new StringBuffer();
            while (true) {
                if (i > file.length() - 1) {
                    lines.setLength(lines.lastIndexOf("\n") + 1);
                    break;
                }
                lines.append(file.charAt(i));
                if (file.charAt(i) == '\n' && (long)i > fileRequest.byteRegion.getLength()) break;
                ++i;
            }
            exactRegion.end = fileRequest.byteRegion.start + (long)i;
            exactRegion.exact = true;
            chunk.setContent(lines.toString());
            chunk.setByteLocation(exactRegion.start);
        }
        fileRequest.status.maybeClearQueue(this.fileResultQueue);
        fileRequest.status.fileRequestCount = this.fileRequestQueue.size();
        ChunkFileResult result = new ChunkFileResult(chunk, fileRequest, this.inputParser, exactRegion, fileRequest.status);
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }

    public long getFileLength() {
        if (this.isAlive()) {
            throw new IllegalStateException("must be called before the thread is started");
        }
        try {
            return this.dataSource.length();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

