/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ChromosomeNameUnnormaliser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceRecord;

public class SAMDataSource
extends DataSource {
    private ChromosomeNameUnnormaliser chromosomeNameUnnormaliser = ChromosomeNameUnnormaliser.newIdentityPreversingUnnormaliser();
    private SAMFileReader reader;

    public SAMDataSource(URL samFile, URL indexFile) throws FileNotFoundException, URISyntaxException {
        super(samFile, SAMHandlerThread.class);
        PrintStream originalErr = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        this.reader = new SAMFileReader(this.file, new File(indexFile.toURI()));
        Iterator i$ = this.reader.getFileHeader().getSequenceDictionary().getSequences().iterator();
        if (i$.hasNext()) {
            SAMSequenceRecord sequenceRecord = (SAMSequenceRecord)i$.next();
            this.chromosomeNameUnnormaliser = new ChromosomeNameUnnormaliser(sequenceRecord.getSequenceName());
        }
        System.setErr(originalErr);
    }

    public SAMFileReader getReader() {
        return this.reader;
    }

    public ChromosomeNameUnnormaliser getChromosomeNameUnnormaliser() {
        return this.chromosomeNameUnnormaliser;
    }
}

