/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Empty
extends Visualisation {
    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    @Override
    public JComponent getVisualisation(DataBean bean) {
        int selectedDataCount = bean != null ? 1 : 0;
        return this.generateContextlinkPanel(selectedDataCount);
    }

    private boolean isDataLoaded() {
        return !Session.getSession().getDataManager().databeans().isEmpty();
    }

    @Override
    public JComponent getVisualisation(List<DataBean> beans) {
        int selectedDataCount = beans != null ? beans.size() : 0;
        return this.generateContextlinkPanel(selectedDataCount);
    }

    @Override
    public boolean canVisualise(DataBean bean) {
        return true;
    }

    @Override
    public boolean canVisualise(List<DataBean> beans) {
        return true;
    }

    @Override
    public boolean isForSingleData() {
        return true;
    }

    @Override
    public boolean isForMultipleDatas() {
        return true;
    }

    private JComponent generateContextlinkPanel(int selectedDataCount) {
        if (!this.isDataLoaded()) {
            return super.getDefaultVisualisation();
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.WHITE);
        JPanel linkPanel = Session.getSession().getPrimaryModule().getContextLinkPanel(selectedDataCount);
        if (linkPanel != null) {
            mainPanel.setLayout(new FlowLayout(0));
            mainPanel.add(linkPanel);
        }
        return mainPanel;
    }
}

