/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.util.ThreadUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class VisualisationTaskManager {
    private LinkedList<VisualisationRunnable> visualisationRunnables = new LinkedList();
    private ClientApplication application = Session.getSession().getApplication();
    private VisualisationFrameManager frameManager;

    public VisualisationTaskManager(VisualisationFrameManager frameManager) {
        this.frameManager = frameManager;
    }

    public void visualise(VisualisationMethodChangedEvent e) {
        Iterator iter = this.visualisationRunnables.iterator();
        while (iter.hasNext()) {
            VisualisationRunnable vr = (VisualisationRunnable)iter.next();
            vr.abandonThread();
            iter.remove();
        }
        VisualisationRunnable runnable = new VisualisationRunnable(e);
        this.visualisationRunnables.add(runnable);
        Thread thread = ThreadUtils.getLowPriorityBackgroundThread(runnable);
        thread.start();
    }

    private class UpdateGuiRunnable
    implements Runnable {
        private JComponent visualisation;
        private VisualisationMethodChangedEvent event;

        public UpdateGuiRunnable(JComponent visualisation, VisualisationMethodChangedEvent event) {
            this.visualisation = visualisation;
            this.event = event;
        }

        @Override
        public void run() {
            VisualisationTaskManager.this.frameManager.showVisualisationComponent(this.visualisation, this.event);
        }
    }

    private class VisualisationRunnable
    implements Runnable {
        private VisualisationMethodChangedEvent event;
        private boolean abandonedThread = false;

        public VisualisationRunnable(VisualisationMethodChangedEvent event) {
            this.event = event;
        }

        public void abandonThread() {
            this.abandonedThread = true;
        }

        @Override
        public void run() {
            try {
                JComponent visualisation;
                JComponent jComponent = visualisation = this.event.getNewMethod() != null ? VisualisationTaskManager.this.frameManager.createVisualisation(this.event) : null;
                if (!this.abandonedThread) {
                    SwingUtilities.invokeAndWait(new UpdateGuiRunnable(visualisation, this.event));
                }
            }
            catch (InterruptedException e) {
                VisualisationTaskManager.this.application.reportException(e);
            }
            catch (InvocationTargetException e) {
                VisualisationTaskManager.this.application.reportException(e);
            }
        }
    }
}

