/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.bsh.BeanShellJobInfo;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Exceptions;
import java.util.List;
import org.apache.log4j.Logger;

public class BeanShellJob
extends OnDiskAnalysisJobBase {
    public static BSParameterSecurityPolicy BS_PARAMETER_SECURITY_POLICY = new BSParameterSecurityPolicy();
    private static final Logger logger = Logger.getLogger(BeanShellJob.class);

    @Override
    protected void execute() throws JobCancelledException {
        List<String> parameters;
        this.updateStateDetailToClient("preparing BeanShell");
        BeanShellJobInfo jobInfo = new BeanShellJobInfo();
        jobInfo.workDir = this.jobWorkDir;
        int i = 0;
        try {
            parameters = this.inputMessage.getParameters(BS_PARAMETER_SECURITY_POLICY, this.analysis);
        }
        catch (JobMessage.ParameterValidityException e) {
            this.outputMessage.setErrorMessage(e.getMessage());
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED_USER_ERROR, "");
            return;
        }
        for (ToolDescription.ParameterDescription param : this.analysis.getParameters()) {
            jobInfo.parameters.put(param.getName(), parameters.get(i));
            ++i;
        }
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("jobInfo", (Object)jobInfo);
            this.updateStateDetailToClient("running the BeanShell script");
            interpreter.eval(this.analysis.getSourceCode());
        }
        catch (TargetError te) {
            String errorMessage = "Running the BeanShell script failed.";
            logger.warn((Object)errorMessage, (Throwable)te);
            this.outputMessage.setErrorMessage(errorMessage);
            this.outputMessage.setOutputText(Exceptions.getStackTrace(te));
            this.updateState(JobState.FAILED, "");
            return;
        }
        catch (EvalError ee) {
            String errorMessage = "The BeanShell script could not be evaluated.";
            this.outputMessage.setErrorMessage(errorMessage);
            this.outputMessage.setOutputText(Exceptions.getStackTrace(ee));
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.updateState(JobState.RUNNING, "BeanShell finished succesfully");
    }

    @Override
    protected void cancelRequested() {
    }

    public static class BSParameterSecurityPolicy
    implements JobMessage.ParameterSecurityPolicy {
        private static final int MAX_VALUE_LENGTH = 10000;

        @Override
        public boolean isValueValid(String value, ToolDescription.ParameterDescription parameterDescription) {
            return value.length() <= 10000;
        }
    }
}

