/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUCache;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleCache
implements ICUCache {
    private static final int DEFAULT_CAPACITY = 16;
    private Reference cacheRef = null;
    private int type = 0;
    private int capacity = 16;

    public SimpleCache() {
    }

    public SimpleCache(int cacheType) {
        this(cacheType, 16);
    }

    public SimpleCache(int cacheType, int initialCapacity) {
        if (cacheType == 1) {
            this.type = cacheType;
        }
        if (initialCapacity > 0) {
            this.capacity = initialCapacity;
        }
    }

    public Object get(Object key) {
        Map map;
        Reference ref = this.cacheRef;
        if (ref != null && (map = (Map)ref.get()) != null) {
            return map.get(key);
        }
        return null;
    }

    public void put(Object key, Object value) {
        Reference ref = this.cacheRef;
        Map<Object, Object> map = null;
        if (ref != null) {
            map = (Map<Object, Object>)ref.get();
        }
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap(this.capacity));
            ref = this.type == 1 ? new WeakReference(map) : new SoftReference(map);
            this.cacheRef = ref;
        }
        map.put(key, value);
    }

    public void clear() {
        this.cacheRef = null;
    }
}

