/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.dbsnp;

import java.io.File;
import java.io.IOException;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.annotation.Strand;
import org.broad.tribble.dbsnp.OldDbSNPCodec;
import org.broad.tribble.dbsnp.OldDbSNPFeature;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class OldDbSNPCodecTest {
    public static final File testFile = new File("test/data/basicDbSNP.dbsnp");
    public static Index index;
    private FeatureReader<OldDbSNPFeature> reader;

    @BeforeTest
    public void beforeTest() {
        index = IndexFactory.createLinearIndex(testFile, new OldDbSNPCodec());
        this.reader = AbstractFeatureReader.getFeatureReader(testFile.getAbsolutePath(), (FeatureCodec)new OldDbSNPCodec(), index);
    }

    @Test
    public void testReadAllLines() {
        try {
            CloseableTribbleIterator<OldDbSNPFeature> iter = this.reader.query("1", 0, 35000000);
            int count = 0;
            while (iter.hasNext()) {
                OldDbSNPFeature feat = (OldDbSNPFeature)iter.next();
                ++count;
            }
            Assert.assertEquals((int)count, (int)42);
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }

    @Test
    public void testReadAllLinesAlternateQueryString1() {
        try {
            CloseableTribbleIterator<OldDbSNPFeature> iter = this.reader.query("1", 433, 1937);
            int count = 0;
            while (iter.hasNext()) {
                OldDbSNPFeature feat = (OldDbSNPFeature)iter.next();
                ++count;
            }
            Assert.assertEquals((int)count, (int)41);
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }

    @Test
    public void testReadAllLinesAlternateQueryString2() {
        try {
            CloseableTribbleIterator<OldDbSNPFeature> iter = this.reader.query("1", 1936, 1937);
            int count = 0;
            while (iter.hasNext()) {
                OldDbSNPFeature feat = (OldDbSNPFeature)iter.next();
                ++count;
            }
            Assert.assertEquals((int)count, (int)1);
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }

    @Test
    public void testReturnedDBSNPEntry() {
        try {
            CloseableTribbleIterator<OldDbSNPFeature> iter = this.reader.query("1", 492, 492);
            if (!iter.hasNext()) {
                Assert.fail((String)"expected at least one entry");
            }
            OldDbSNPFeature feat = (OldDbSNPFeature)iter.next();
            Assert.assertTrue((boolean)feat.getChr().equals("1"));
            Assert.assertEquals((int)feat.getStart(), (int)492);
            Assert.assertEquals((int)feat.getEnd(), (int)492);
            Assert.assertTrue((boolean)feat.getRsID().equals("rs55998931"));
            Assert.assertEquals((int)feat.getScore(), (int)0);
            Assert.assertEquals((Object)((Object)feat.getStrand()), (Object)((Object)Strand.POSITIVE));
            Assert.assertEquals((String)feat.getNCBIRefBase(), (String)"C");
            Assert.assertEquals((String)feat.getUCSCRefBase(), (String)"C");
            Assert.assertEquals((int)2, (int)feat.getObserved().length);
            Assert.assertTrue((boolean)"C".equals(feat.getObserved()[0]));
            Assert.assertTrue((boolean)"T".equals(feat.getObserved()[1]));
            Assert.assertTrue((boolean)"genomic".equals(feat.getMolType()));
            Assert.assertTrue((boolean)"single".equals(feat.getVariantType()));
            Assert.assertTrue((boolean)"unknown".equals(feat.getValidationStatus()));
            Assert.assertEquals((double)feat.getAvHet(), (double)0.0, (double)1.0E-4);
            Assert.assertEquals((double)feat.getAvHetSE(), (double)0.0, (double)1.0E-4);
            Assert.assertTrue((boolean)"unknown".equals(feat.getFunction()));
            Assert.assertTrue((boolean)"exact".equals(feat.getLocationType()));
            Assert.assertEquals((int)feat.getWeight(), (int)1);
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }
}

