/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GeneSearchFileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.gbrowser.index.GeneResult;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class GeneSearchHandler
extends AreaRequestHandler {
    private LineDataSource data;
    private GeneSearchFileFetcherThread fileFetcher;
    private BlockingQueue<BpCoordFileRequest> fileRequestQueue = new LinkedBlockingQueue<BpCoordFileRequest>();
    private ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue = new ConcurrentLinkedQueue();

    public GeneSearchHandler(DataSource file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.data = (LineDataSource)file;
    }

    @Override
    public synchronized void run() {
        this.fileFetcher = new GeneSearchFileFetcherThread(this.fileRequestQueue, this.fileResultQueue, this, this.data);
        this.fileFetcher.start();
        super.run();
    }

    @Override
    protected boolean checkOtherQueues() {
        ParsedFileResult fileResult = null;
        fileResult = this.fileResultQueue.poll();
        if (fileResult != null) {
            this.processFileResult(fileResult);
        }
        return fileResult != null;
    }

    private void processFileResult(ParsedFileResult fileResult) {
        if (fileResult.getFileRequest().areaRequest instanceof GeneRequest) {
            GeneRequest geneRequest = (GeneRequest)fileResult.getFileRequest().areaRequest;
            this.createAreaResult(new GeneResult(fileResult.getStatus(), fileResult.getContents(), geneRequest.getSearchString()));
        }
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        super.processAreaRequest(areaRequest);
        if (areaRequest.status.poison) {
            BpCoordFileRequest fileRequest = new BpCoordFileRequest(areaRequest, null, null, areaRequest.status);
            this.fileRequestQueue.add(fileRequest);
            return;
        }
        this.fileRequestQueue.add(new BpCoordFileRequest(areaRequest, areaRequest.start, areaRequest.end, areaRequest.status));
    }
}

