/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class LoginModuleBase
implements LoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        boolean authSuccessful;
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler.");
        }
        Callback[] callbacks = new Callback[2];
        NameCallback nameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        callbacks[0] = nameCallback;
        callbacks[1] = passwordCallback;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException("Could not get username and password due to IO error.");
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Could not get username and password.");
        }
        this.username = nameCallback.getName();
        if (this.username == null) {
            throw new LoginException("Username is null.");
        }
        char[] tempPassword = passwordCallback.getPassword();
        if (tempPassword == null) {
            throw new LoginException("Password is null.");
        }
        char[] password = new char[tempPassword.length];
        System.arraycopy(tempPassword, 0, password, 0, tempPassword.length);
        passwordCallback.clearPassword();
        try {
            authSuccessful = this.authenticate(this.username, password);
        }
        catch (IOException e1) {
            try {
                throw new LoginException("Could not verify username and password for " + this.username);
            }
            catch (Throwable throwable) {
                for (int i = 0; i < password.length; ++i) {
                    password[i] = 32;
                }
                password = null;
                throw throwable;
            }
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = 32;
        }
        password = null;
        if (authSuccessful) {
            this.succeeded = true;
            return true;
        }
        this.username = null;
        throw new FailedLoginException("Login failed.");
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.succeeded) {
            // empty if block
        }
        this.username = null;
        this.commitSucceeded = true;
        if (this.succeeded && !this.commitSucceeded) {
            throw new LoginException("Commit failed.");
        }
        return this.succeeded && this.commitSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        this.username = null;
        return this.succeeded;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    protected abstract boolean authenticate(String var1, char[] var2) throws IOException;

    protected static void skipToLineEnd(Reader reader) throws IOException {
        int next = reader.read();
        while (next != -1) {
            if (LoginModuleBase.isNewLineChar((char)next)) {
                return;
            }
            next = reader.read();
        }
    }

    protected static int readToken(char[] target, Reader reader) throws IOException {
        int i;
        for (i = 0; i < target.length; ++i) {
            int input = reader.read();
            if (input == -1) {
                if (i != 0) break;
                return -1;
            }
            if (LoginModuleBase.isNewLineChar((char)input)) break;
            target[i] = (char)input;
        }
        return i;
    }

    protected static boolean isNewLineChar(char c) {
        return c == '\n' || c == '\r';
    }
}

