/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.PlotConsensus;
import org.emboss.jemboss.editor.PrettyPlotJFrame;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceJPanel;
import org.emboss.jemboss.editor.SequenceNameJButton;
import org.emboss.jemboss.gui.form.MultiLineToolTipUI;

public class GraphicSequenceCollection
extends JPanel
implements Printable,
Scrollable {
    private Vector removedSeqs = new Vector();
    protected Vector seqs;
    protected Vector graphicSequence;
    protected Vector graphicName;
    protected Hashtable colorScheme;
    private PlotConsensus pc = null;
    private int hgt;
    private int len;
    protected int MAXSEQLENGTH = 0;
    private int numResiduePerLine = 0;
    protected SequenceJPanel numberDraw;
    protected JScrollPane jspSequence;
    private JPanel seqNamePanel;
    protected Box seqBox;
    protected Box seqNameBox;
    private Box plotconsSeqBox = null;
    protected boolean drawSequence;
    protected boolean drawBlackBox;
    protected boolean drawColorBox;
    protected boolean drawNumber;
    private boolean prettPlot = false;
    private int plotConStrut = 20;
    private PrettyPlotJFrame prettyPlot;
    private Matrix mat;

    public GraphicSequenceCollection(Vector vector, Hashtable hashtable, JScrollPane jScrollPane, boolean bl, boolean bl2, boolean bl3, boolean bl4, JTextField jTextField) {
        super(new BorderLayout());
        this.seqs = vector;
        this.colorScheme = hashtable;
        this.jspSequence = jScrollPane;
        this.drawSequence = bl;
        this.drawBlackBox = bl2;
        this.drawColorBox = bl3;
        this.drawNumber = bl4;
        jScrollPane.getViewport().setBackground(Color.white);
        this.setBackground(Color.white);
        MultiLineToolTipUI.initialize();
        this.graphicSequence = new Vector();
        this.graphicName = new Vector();
        this.setMaxSeqLength();
        Box box = new Box(1);
        this.seqBox = new Box(1);
        box.add(this.seqBox);
        Box box2 = new Box(1);
        this.seqNameBox = new Box(1);
        box2.add(this.seqNameBox);
        this.seqNamePanel = new JPanel(new BorderLayout());
        this.seqNamePanel.add((Component)box2, "Center");
        this.seqNamePanel.setBackground(Color.white);
        jScrollPane.setRowHeaderView(this.seqNamePanel);
        if (bl4) {
            this.drawNumber();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addSequence((Sequence)enumeration.nextElement(), false, 0, 0);
        }
        box2.add(Box.createVerticalGlue());
        box.add(Box.createVerticalGlue());
        this.plotconsSeqBox = new Box(1);
        box.add(this.plotconsSeqBox);
        this.add((Component)box, "Center");
        int n = this.getNameWidth();
        this.seqNamePanel.setPreferredSize(new Dimension(n, 2000));
    }

    public GraphicSequenceCollection(Vector vector, JScrollPane jScrollPane, boolean bl, boolean bl2, boolean bl3, boolean bl4, JTextField jTextField) {
        this(vector, null, jScrollPane, bl, bl2, bl3, bl4, jTextField);
    }

    protected Vector getSequenceCollection() {
        return this.seqs;
    }

    protected Sequence getConsensusSequence() {
        Enumeration enumeration = this.seqs.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            String string = sequence.getName();
            if (!string.equals("Consensus")) continue;
            return sequence;
        }
        return null;
    }

    protected int getNumberSequences() {
        return this.seqs.size();
    }

    protected Point getViewPosition() {
        return this.jspSequence.getViewport().getViewPosition();
    }

    protected Rectangle getViewRect() {
        Rectangle rectangle = this.jspSequence.getViewport().getViewRect();
        return rectangle;
    }

    protected void showConsensusPlot(File file, int n) {
        this.deleteConsensusPlot();
        SequenceJPanel sequenceJPanel = (SequenceJPanel)this.graphicSequence.get(0);
        int n2 = sequenceJPanel.getSequenceResidueWidth();
        this.pc = new PlotConsensus(file, this.seqs, n, n2, this);
        this.pc.setBackground(Color.white);
        Box box = new Box(0);
        box.add(this.pc);
        box.add(Box.createHorizontalGlue());
        this.plotconsSeqBox.add(Box.createVerticalStrut(this.plotConStrut));
        this.plotconsSeqBox.add(box);
        this.plotconsSeqBox.add(Box.createVerticalGlue());
        Dimension dimension = this.getPanelSize();
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setJScrollPaneViewportView();
    }

    protected void showConsensusPlot(Matrix matrix, int n) {
        this.deleteConsensusPlot();
        SequenceJPanel sequenceJPanel = (SequenceJPanel)this.graphicSequence.get(0);
        int n2 = sequenceJPanel.getSequenceResidueWidth();
        this.pc = new PlotConsensus(matrix, this.seqs, n, n2, this);
        this.pc.setBackground(Color.white);
        Box box = new Box(0);
        box.add(this.pc);
        box.add(Box.createHorizontalGlue());
        this.plotconsSeqBox.add(Box.createVerticalStrut(20));
        this.plotconsSeqBox.add(box);
        this.plotconsSeqBox.add(Box.createVerticalGlue());
        Dimension dimension = this.getPanelSize();
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setJScrollPaneViewportView();
    }

    protected void deleteConsensusPlot() {
        this.plotconsSeqBox.removeAll();
    }

    protected void setMaxSequenceLength(int n) {
        if (n > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = n;
        }
    }

    protected void setMaxSeqLength() {
        this.MAXSEQLENGTH = 0;
        Enumeration enumeration = this.seqs.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            if (sequence.getSequence().length() <= this.MAXSEQLENGTH) continue;
            this.MAXSEQLENGTH = sequence.getSequence().length();
        }
    }

    public int getMaxSeqLength() {
        return this.MAXSEQLENGTH;
    }

    protected void setSequenceLock(boolean bl) {
        JComponent jComponent;
        Enumeration enumeration = this.graphicName.elements();
        if (!bl) {
            while (enumeration.hasMoreElements()) {
                ((SequenceNameJButton)enumeration.nextElement()).setSelected(false);
            }
            enumeration = this.graphicSequence.elements();
            while (enumeration.hasMoreElements()) {
                ((SequenceJPanel)enumeration.nextElement()).detachAll();
            }
            return;
        }
        int n = 0;
        Vector<SequenceJPanel> vector = new Vector<SequenceJPanel>();
        while (enumeration.hasMoreElements()) {
            jComponent = (SequenceNameJButton)enumeration.nextElement();
            if (jComponent.isSelected()) {
                vector.add((SequenceJPanel)this.graphicSequence.get(n));
            }
            ++n;
        }
        for (n = 0; n < vector.size(); ++n) {
            jComponent = (SequenceJPanel)vector.get(n);
            for (int i = 0; i < vector.size(); ++i) {
                if (n == i) continue;
                ((SequenceJPanel)vector.get(i)).attach((SequenceJPanel)jComponent);
            }
        }
    }

    protected void setNumberSize() {
        Dimension dimension = this.numberDraw.getMaximumSize();
        int n = this.numberDraw.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.5);
        this.numberDraw.setMaximumSize(new Dimension(n, (int)dimension.getHeight()));
    }

    protected void setMatrix(Matrix matrix) {
        this.mat = matrix;
    }

    protected Color getColor(String string, int n, String string2) {
        if (string.equals("-") || string.equals(".")) {
            return Color.black;
        }
        int n2 = 1;
        int n3 = 0;
        Enumeration enumeration = this.seqs.elements();
        while (enumeration.hasMoreElements()) {
            ++n3;
            Sequence sequence = (Sequence)enumeration.nextElement();
            if (string2.equals(sequence.getName())) continue;
            SequenceJPanel sequenceJPanel = (SequenceJPanel)this.graphicSequence.get(n3);
            if (n >= sequence.getLength() || !sequenceJPanel.isPrettyPlot() || !sequence.getResidue(n).equalsIgnoreCase(string)) continue;
            ++n2;
        }
        if (n2 >= this.prettyPlot.getMinimumIdentity(n3)) {
            return this.prettyPlot.getIDColour();
        }
        if (this.mat != null) {
            double d = this.prettyPlot.getMatchThreshold();
            int n4 = this.mat.getMatrixIndex(string);
            int[][] nArray = this.mat.getMatrix();
            float f = 0.0f;
            n3 = 0;
            enumeration = this.seqs.elements();
            while (enumeration.hasMoreElements()) {
                Sequence sequence = (Sequence)enumeration.nextElement();
                SequenceJPanel sequenceJPanel = (SequenceJPanel)this.graphicSequence.get(++n3);
                if (n >= sequence.getLength() || !sequenceJPanel.isPrettyPlot()) continue;
                int n5 = this.mat.getMatrixIndex(sequence.getResidue(n));
                if (n4 < 0 || n5 < 0 || nArray[n4][n5] <= 0) continue;
                f += sequence.getWeight();
            }
            if ((double)f >= d) {
                return this.prettyPlot.getMatchColour();
            }
        }
        return Color.black;
    }

    protected Color getPrettyBackground(Color color) {
        if (color.equals(this.prettyPlot.getIDColour())) {
            return this.prettyPlot.getIDBackgroundColour();
        }
        if (color.equals(this.prettyPlot.getMatchColour())) {
            return this.prettyPlot.getMatchBackgroundColour();
        }
        return null;
    }

    protected boolean isPrettyBox() {
        return this.prettyPlot.isPrettyBox();
    }

    protected int testUpAndDown(int n, Sequence sequence) {
        Serializable serializable;
        Object object;
        int n2 = this.seqs.indexOf(sequence);
        int n3 = -1;
        if (n2 == 0) {
            n3 = 1;
        } else {
            Sequence sequence2 = (Sequence)this.seqs.get(n2 - 1);
            object = sequence2.getSequence().substring(n, n + 1);
            serializable = this.getColor((String)object, n, sequence2.getName());
            if (((Color)serializable).equals(Color.black)) {
                n3 = 1;
            }
        }
        int n4 = -1;
        if (n2 + 1 == this.seqs.size()) {
            n4 = 1;
        } else {
            object = (Sequence)this.seqs.get(n2 + 1);
            serializable = (SequenceJPanel)this.graphicSequence.get(n2 + 2);
            String string = ((Sequence)object).getSequence().substring(n, n + 1);
            Color color = this.getColor(string, n, ((Sequence)object).getName());
            if (color.equals(Color.black) || !((SequenceJPanel)serializable).isPrettyPlot()) {
                n4 = 1;
            }
        }
        if (n3 > -1 && n4 > -1) {
            return 3;
        }
        if (n4 > -1) {
            return 2;
        }
        if (n3 > -1) {
            return 1;
        }
        return -1;
    }

    private Sequence removeSequence(String string) {
        boolean bl = false;
        int n = 0;
        Enumeration enumeration = this.seqs.elements();
        Sequence sequence = null;
        while (enumeration.hasMoreElements()) {
            sequence = (Sequence)enumeration.nextElement();
            if (sequence.getName().equals(string)) {
                this.removedSeqs.add(sequence);
                bl = true;
                this.seqs.remove(sequence);
                break;
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        if (this.drawNumber) {
            ++n;
        }
        this.seqBox.remove(n);
        this.seqNameBox.remove(n);
        this.graphicName.removeElementAt(n);
        this.graphicSequence.removeElementAt(n);
        return sequence;
    }

    protected void deleteSequence(String string) {
        this.removeSequence(string);
        this.setMaxSeqLength();
        this.numberDraw.setSequenceLength(this.MAXSEQLENGTH);
        Dimension dimension = this.getPanelSize();
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.numberDraw.setMaximumSize(this.numberDraw.getPreferredSize());
        this.numberDraw.setMinimumSize(this.numberDraw.getPreferredSize());
        this.setJScrollPaneViewportView();
    }

    protected void moveSequence(String string, int n) {
        Sequence sequence = this.removeSequence(string);
        this.addSequence(sequence, true, 0, 0, n);
    }

    protected void idSort() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.seqs.elements();
        while (enumeration.hasMoreElements()) {
            object = ((Sequence)enumeration.nextElement()).getName();
            if (((String)object).equals("Consensus")) continue;
            ++n;
        }
        object = new String[n];
        int n2 = 0;
        enumeration = this.seqs.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((Sequence)enumeration.nextElement()).getName();
            if (string.equals("Consensus")) continue;
            object[n2] = new String(string);
            ++n2;
        }
        Arrays.sort((Object[])object);
        for (n2 = 0; n2 < n; ++n2) {
            this.moveSequence((String)object[n2], n2);
        }
    }

    protected void addSequence(Sequence sequence, boolean bl, int n, int n2, int n3) {
        if (bl) {
            this.seqs.add(n3, sequence);
        }
        if (this.drawNumber) {
            ++n3;
        }
        SequenceJPanel sequenceJPanel = new SequenceJPanel(sequence, this, this.drawSequence, this.drawBlackBox, this.drawColorBox, this.colorScheme, n);
        this.graphicSequence.add(n3, sequenceJPanel);
        Box box = new Box(0);
        box.add(sequenceJPanel);
        box.add(Box.createHorizontalGlue());
        this.seqBox.add((Component)box, n3);
        sequenceJPanel.setToolTipText("");
        SequenceNameJButton sequenceNameJButton = new SequenceNameJButton(sequence, n);
        this.graphicName.add(n3, sequenceNameJButton);
        box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(sequenceNameJButton);
        this.seqNameBox.add((Component)box, n3);
        if (sequence.getLength() > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = sequence.getLength();
        }
        Dimension dimension = sequenceJPanel.getMaximumSize();
        int n4 = sequenceJPanel.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
        sequenceJPanel.setMaximumSize(new Dimension(n4, (int)dimension.getHeight()));
    }

    protected void addSequence(Sequence sequence, boolean bl, int n, int n2) {
        if (bl) {
            this.seqs.add(sequence);
        }
        SequenceJPanel sequenceJPanel = new SequenceJPanel(sequence, this, this.drawSequence, this.drawBlackBox, this.drawColorBox, this.colorScheme, n2, n);
        this.graphicSequence.add(sequenceJPanel);
        Box box = new Box(0);
        box.add(sequenceJPanel);
        box.add(Box.createHorizontalGlue());
        this.seqBox.add(box);
        sequenceJPanel.setToolTipText("");
        SequenceNameJButton sequenceNameJButton = new SequenceNameJButton(sequence, n);
        this.graphicName.add(sequenceNameJButton);
        box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(sequenceNameJButton);
        this.seqNameBox.add(box);
        if (sequence.getLength() > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = sequence.getLength();
        }
        Dimension dimension = sequenceJPanel.getMaximumSize();
        int n3 = sequenceJPanel.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
        sequenceJPanel.setMaximumSize(new Dimension(n3, (int)dimension.getHeight()));
    }

    public Dimension getViewSize() {
        Serializable serializable;
        this.hgt = 1;
        this.len = 0;
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (SequenceJPanel)enumeration.nextElement();
            this.hgt += ((SequenceJPanel)serializable).getSequenceHeight();
            if (this.len >= ((SequenceJPanel)serializable).getSequenceWidth()) continue;
            this.len = ((SequenceJPanel)serializable).getSequenceWidth();
        }
        if (this.pc != null) {
            serializable = this.pc.getPreferredSize();
            this.hgt = this.hgt + (int)((Dimension)serializable).getHeight() + this.plotConStrut;
        }
        return new Dimension(this.len, this.hgt);
    }

    public String getName(int n) {
        return ((Sequence)this.seqs.get(n)).getName();
    }

    public Dimension getNameViewSize() {
        int n = this.getNameHeight();
        int n2 = this.getNameWidth();
        return new Dimension(n2, n);
    }

    public Dimension getPanelSize() {
        this.getViewSize();
        return new Dimension(this.len, this.hgt);
    }

    public int getNameHeight() {
        int n = 0;
        Enumeration enumeration = this.graphicName.elements();
        while (enumeration.hasMoreElements()) {
            n += ((SequenceNameJButton)enumeration.nextElement()).getPanelHeight();
        }
        return n;
    }

    public int getNameWidth() {
        int n = 0;
        Enumeration enumeration = this.graphicName.elements();
        while (enumeration.hasMoreElements()) {
            SequenceNameJButton sequenceNameJButton = (SequenceNameJButton)enumeration.nextElement();
            if (n >= sequenceNameJButton.getPanelWidth()) continue;
            n = sequenceNameJButton.getPanelWidth();
        }
        return n;
    }

    public void setNamePanelWidth(int n) {
        this.seqNamePanel.setPreferredSize(new Dimension(n, 1000));
    }

    public int getPanelHeight() {
        this.getViewSize();
        return this.hgt;
    }

    public int getPanelWidth() {
        this.getViewSize();
        return this.len;
    }

    public Vector getGraphicSequence() {
        return this.graphicSequence;
    }

    public void setDrawBoxes(boolean bl) {
        this.drawBlackBox = bl;
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            ((SequenceJPanel)enumeration.nextElement()).setDrawBoxes(bl);
        }
        this.setJScrollPaneViewportView();
    }

    public void setDrawColor(boolean bl) {
        this.drawColorBox = bl;
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            ((SequenceJPanel)enumeration.nextElement()).setDrawColor(bl);
        }
        this.setJScrollPaneViewportView();
    }

    public void setFontSizeForCollection(int n) {
        int n2;
        Serializable serializable;
        Object object;
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            object = (SequenceJPanel)enumeration.nextElement();
            ((SequenceJPanel)object).setFontSize(n);
            serializable = ((JComponent)object).getMaximumSize();
            n2 = ((SequenceJPanel)object).getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
            ((JComponent)object).setMaximumSize(new Dimension(n2, (int)((Dimension)serializable).getHeight()));
        }
        object = this.graphicName.elements();
        while (object.hasMoreElements()) {
            serializable = (SequenceNameJButton)object.nextElement();
            ((SequenceNameJButton)serializable).setFontSize(n);
            ((JComponent)serializable).setMaximumSize(((SequenceNameJButton)serializable).getPreferredSize());
        }
        if (this.pc != null) {
            serializable = (SequenceJPanel)this.graphicSequence.get(0);
            n2 = ((SequenceJPanel)serializable).getSequenceResidueWidth();
            this.pc.setInterval(n2);
            this.pc.setPlotSize();
        }
        serializable = this.getPanelSize();
        this.setMinimumSize((Dimension)serializable);
        this.setPreferredSize((Dimension)serializable);
        this.setNamePanelWidth(this.getNameWidth());
        this.setJScrollPaneViewportView();
    }

    public int getFontSize() {
        return ((SequenceJPanel)this.graphicSequence.get(0)).getFontSize();
    }

    public int findPattern(String string, int n, boolean bl) {
        int n2;
        int n3 = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceResidueWidth();
        Rectangle rectangle = this.getViewRect();
        int n4 = rectangle.y;
        int n5 = rectangle.x / n3;
        int n6 = rectangle.width / n3;
        string = string.toLowerCase();
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            SequenceJPanel sequenceJPanel = (SequenceJPanel)enumeration.nextElement();
            sequenceJPanel.showPattern(string);
        }
        if (n > -1) {
            n5 = n;
        }
        if ((n2 = this.searchSequences(n5, string)) > -1) {
            int n7 = this.findMiddle(n2, n6, string);
            this.jspSequence.getViewport().setViewPosition(new Point(n7 * n3, n4));
        } else if (bl) {
            n2 = this.searchSequences(0, string);
            if (n2 > -1) {
                int n8 = this.findMiddle(n2, n6, string);
                this.jspSequence.getViewport().setViewPosition(new Point(n8 * n3, n4));
            }
        } else if (!bl) {
            n2 = n;
        }
        return n2 + 1;
    }

    private int searchSequences(int n, String string) {
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = this.seqs.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            int n4 = sequence.getSequence().toLowerCase().indexOf(string, n);
            if (n4 <= -1) continue;
            if (n3 == 0 || n4 < n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return n2;
    }

    private int findMiddle(int n, int n2, String string) {
        int n3 = n2 / 2;
        int n4 = n <= n3 ? 0 : n - n3 + string.length() / 2;
        return n4;
    }

    public void setColorScheme(Hashtable hashtable) {
        this.colorScheme = hashtable;
        this.drawColorBox = true;
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            SequenceJPanel sequenceJPanel = (SequenceJPanel)enumeration.nextElement();
            sequenceJPanel.setColorScheme(hashtable);
            sequenceJPanel.setDrawColor(this.drawColorBox);
        }
    }

    public void setPrettyPlot(boolean bl, PrettyPlotJFrame prettyPlotJFrame) {
        this.prettyPlot = prettyPlotJFrame;
        Enumeration enumeration = this.graphicSequence.elements();
        while (enumeration.hasMoreElements()) {
            ((SequenceJPanel)enumeration.nextElement()).setPrettyPlot(bl);
        }
    }

    public void setJScrollPaneViewportView() {
        this.jspSequence.setViewportView(this);
    }

    public int getNumberPages(PageFormat pageFormat) {
        return this.getNumberPages(pageFormat, this.getResiduesPerLine(pageFormat));
    }

    public int getNumberPages(PageFormat pageFormat, int n) {
        double d = pageFormat.getImageableHeight();
        int n2 = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceHeight();
        int n3 = (int)(d / (double)((this.graphicSequence.size() + 2) * n2));
        int n4 = this.MAXSEQLENGTH / (n3 * n) + 1;
        return n4;
    }

    public Dimension getImageableSize(int n) {
        SequenceJPanel sequenceJPanel = (SequenceJPanel)this.graphicSequence.get(0);
        int n2 = sequenceJPanel.getSequenceHeight();
        int n3 = (this.graphicSequence.size() + 1) * n2;
        int n4 = Math.round((float)this.MAXSEQLENGTH / (float)n + 0.5f) * n3;
        int n5 = sequenceJPanel.getResidueWidth() * (n + 2) + this.getNameWidth();
        return new Dimension(n5, n4);
    }

    public int getResiduesPerLine(PageFormat pageFormat) {
        double d = pageFormat.getImageableWidth() - (double)this.getNameWidth();
        int n = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceResidueWidth();
        return (int)(d / (double)n);
    }

    public int getResiduesPerPage(PageFormat pageFormat, int n) {
        double d = pageFormat.getImageableHeight();
        int n2 = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceHeight();
        int n3 = (int)(d / (double)(n2 * (this.graphicSequence.size() + 2)));
        return n3 * n;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.drawSequences(graphics2D, pageFormat, n, this.numResiduePerLine);
        return 0;
    }

    protected void setNumberOfResiduesPerLine(int n) {
        this.numResiduePerLine = n;
    }

    public void drawSequences(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        int n2 = this.getResiduesPerLine(pageFormat);
        this.drawSequences(graphics2D, pageFormat, n, n2);
    }

    public void drawSequences(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n3 = this.getResiduesPerPage(pageFormat, n2);
        int n4 = n3 * n;
        int n5 = n4 + n3;
        if (n5 > this.MAXSEQLENGTH) {
            n5 = this.MAXSEQLENGTH;
        }
        for (int i = n4; i < n5; i += n2) {
            Enumeration enumeration = this.graphicSequence.elements();
            SequenceJPanel sequenceJPanel = null;
            while (enumeration.hasMoreElements()) {
                int n6 = i + n2;
                if (n6 > n5) {
                    n6 = n5;
                }
                sequenceJPanel = (SequenceJPanel)enumeration.nextElement();
                sequenceJPanel.getSequencePrintGraphic(graphics2D, this.getNameWidth(), i, n6);
                sequenceJPanel.getNamePrintGraphic(graphics2D);
                graphics2D.translate(0, sequenceJPanel.getSequenceHeight());
            }
            graphics2D.translate(0, sequenceJPanel.getSequenceHeight());
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 60;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 60;
    }

    public static void main(String[] stringArray) {
        Vector<Sequence> vector = new Vector<Sequence>();
        vector.add(new Sequence("Seq1", "ACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTAT"));
        vector.add(new Sequence("Seq2", "ACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTAT"));
        JScrollPane jScrollPane = new JScrollPane();
        GraphicSequenceCollection graphicSequenceCollection = new GraphicSequenceCollection(vector, null, jScrollPane, true, true, true, false, null);
        jScrollPane.setViewportView(graphicSequenceCollection);
        JFrame jFrame = new JFrame("Sequence Panel");
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        jPanel.add(jScrollPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    protected void drawNumber() {
        this.numberDraw = new SequenceJPanel(10, this.MAXSEQLENGTH);
        this.graphicSequence.add(this.numberDraw);
        Box box = new Box(0);
        box.add(this.numberDraw);
        box.add(Box.createHorizontalGlue());
        this.seqBox.add(box);
        this.setNumberSize();
        SequenceNameJButton sequenceNameJButton = new SequenceNameJButton(new Sequence(" "), 0);
        this.graphicName.add(sequenceNameJButton);
        this.seqNameBox.add(sequenceNameJButton);
    }

    protected void addAnnotationSequence(Sequence sequence) {
        this.addSequence(sequence, true, 0, this.getFontSize());
    }
}

