/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.activemq.console.filter.AbstractQueryFilter;

public class MBeansObjectNameQueryFilter
extends AbstractQueryFilter {
    public static final String DEFAULT_JMX_DOMAIN = "org.apache.activemq";
    public static final String QUERY_EXP_PREFIX = "MBeans.QueryExp.";
    private MBeanServerConnection jmxConnection;

    public MBeansObjectNameQueryFilter(MBeanServerConnection jmxConnection) {
        super(null);
        this.jmxConnection = jmxConnection;
    }

    public List query(List queries) throws MalformedObjectNameException, IOException {
        if (queries == null || queries.isEmpty()) {
            return this.queryMBeans(new ObjectName("org.apache.activemq:*"), null);
        }
        String objNameQuery = "";
        String queryExp = "";
        for (String key : queries) {
            String val = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                val = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            if (val.startsWith(QUERY_EXP_PREFIX) || key.equals("") || val.equals("")) continue;
            objNameQuery = objNameQuery + key + "=" + val + ",";
        }
        objNameQuery = objNameQuery + "*";
        return this.queryMBeans(new ObjectName("org.apache.activemq:" + objNameQuery), queryExp);
    }

    protected List queryMBeans(ObjectName objName, String queryExpStr) throws IOException {
        QueryExp queryExp = this.createQueryExp(queryExpStr);
        ArrayList<ObjectInstance> mbeans = new ArrayList<ObjectInstance>(this.jmxConnection.queryMBeans(objName, queryExp));
        return mbeans;
    }

    protected QueryExp createQueryExp(String queryExpStr) {
        return null;
    }
}

