/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.EmptyReplacedElement;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.swing.SwingReplacedElement;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class SwingReplacedElementFactory
implements ReplacedElementFactory {
    protected Map imageComponents;
    protected LinkedHashMap forms;

    public ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        JComponent cc = null;
        if (e == null) {
            return null;
        }
        if (context.getNamespaceHandler().isImageElement(e)) {
            return this.replaceImage(uac, context, e, cssWidth, cssHeight);
        }
        Element parentForm = this.getParentForm(e, context);
        XhtmlForm form = this.getForm(parentForm);
        if (form == null) {
            form = new XhtmlForm(uac, parentForm);
            this.addForm(parentForm, form);
        }
        if ((cc = form.addComponent(e)) == null) {
            return null;
        }
        if (cc == XhtmlForm.HIDDEN_FIELD) {
            return new EmptyReplacedElement(0, 0);
        }
        SwingReplacedElement result = new SwingReplacedElement(cc);
        if (context.isInteractive()) {
            context.getCanvas().add(cc);
        }
        return result;
    }

    protected ReplacedElement replaceImage(UserAgentCallback uac, LayoutContext context, Element elem, int cssWidth, int cssHeight) {
        ReplacedElement re = null;
        re = this.lookupImageReplacedElement(elem);
        if (re == null) {
            Image im = null;
            String imageSrc = context.getNamespaceHandler().getImageSourceURI(elem);
            if (imageSrc == null || imageSrc.length() == 0) {
                XRLog.layout(Level.WARNING, "No source provided for img element.");
                re = this.newIrreplaceableImageElement(cssWidth, cssHeight);
            } else {
                FSImage fsImage = uac.getImageResource(imageSrc).getImage();
                if (fsImage != null) {
                    im = ((AWTFSImage)fsImage).getImage();
                }
                re = im != null ? new ImageReplacedElement(im, cssWidth, cssHeight) : this.newIrreplaceableImageElement(cssWidth, cssHeight);
            }
            this.storeImageReplacedElement(elem, re);
        }
        return re;
    }

    protected ReplacedElement newIrreplaceableImageElement(int cssWidth, int cssHeight) {
        ReplacedElement mre;
        BufferedImage missingImage = null;
        try {
            missingImage = ImageUtil.createCompatibleBufferedImage(cssWidth, cssHeight, 1);
            Graphics2D g = missingImage.createGraphics();
            g.setColor(Color.BLACK);
            g.setBackground(Color.WHITE);
            g.setFont(new Font("Serif", 0, 12));
            g.drawString("Missing", 0, 12);
            g.dispose();
            mre = new ImageReplacedElement(missingImage, cssWidth, cssHeight);
        }
        catch (Exception e) {
            mre = new EmptyReplacedElement(cssWidth < 0 ? 0 : cssWidth, cssHeight < 0 ? 0 : cssHeight);
        }
        return mre;
    }

    protected void storeImageReplacedElement(Element e, ReplacedElement cc) {
        if (this.imageComponents == null) {
            this.imageComponents = new HashMap();
        }
        this.imageComponents.put(e, cc);
    }

    protected ReplacedElement lookupImageReplacedElement(Element e) {
        if (this.imageComponents == null) {
            return null;
        }
        ReplacedElement replacedElement = (ReplacedElement)this.imageComponents.get(e);
        return replacedElement;
    }

    protected void addForm(Element e, XhtmlForm f) {
        if (this.forms == null) {
            this.forms = new LinkedHashMap();
        }
        this.forms.put(e, f);
    }

    protected XhtmlForm getForm(Element e) {
        if (this.forms == null) {
            return null;
        }
        return (XhtmlForm)this.forms.get(e);
    }

    protected Element getParentForm(Element e, LayoutContext context) {
        Node node = e;
        while ((node = node.getParentNode()).getNodeType() == 1 && !context.getNamespaceHandler().isFormElement((Element)node)) {
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        return (Element)node;
    }

    public void reset() {
        this.forms = null;
        this.imageComponents = null;
    }

    public void remove(Element e) {
        if (this.forms != null) {
            this.forms.remove(e);
        }
        if (this.imageComponents != null) {
            this.imageComponents.remove(e);
        }
    }
}

