/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;

public class ObjectStream
extends Stream {
    private static final Logger logger = Logger.getLogger(Form.class.toString());
    private boolean m_bInited;
    private SeekableInput m_DecodedStream;
    private int[] m_iaObjectNumbers;
    private long[] m_laObjectOffset;

    public ObjectStream(Library l, Hashtable h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.m_bInited) {
            return;
        }
        this.m_bInited = true;
        int numObjects = this.library.getInt(this.entries, "N");
        long firstObjectsOffset = this.library.getLong(this.entries, "First");
        byte[] data = this.getBytes();
        this.m_DecodedStream = new SeekableByteArrayInputStream(data);
        this.m_DecodedStream.beginThreadAccess();
        this.m_iaObjectNumbers = new int[numObjects];
        this.m_laObjectOffset = new long[numObjects];
        try {
            Parser parser = new Parser(this.m_DecodedStream);
            for (int i = 0; i < numObjects; ++i) {
                this.m_iaObjectNumbers[i] = parser.getIntSurroundedByWhitespace();
                this.m_laObjectOffset[i] = parser.getLongSurroundedByWhitespace() + firstObjectsOffset;
            }
        }
        finally {
            this.m_DecodedStream.endThreadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadObject(Library library, int objectIndex) {
        this.init();
        if (this.m_iaObjectNumbers == null || this.m_laObjectOffset == null || this.m_iaObjectNumbers.length != this.m_laObjectOffset.length || objectIndex < 0 || objectIndex >= this.m_iaObjectNumbers.length) {
            return false;
        }
        boolean gotSomething = false;
        try {
            int objectNumber = this.m_iaObjectNumbers[objectIndex];
            long position = this.m_laObjectOffset[objectIndex];
            this.m_DecodedStream.beginThreadAccess();
            this.m_DecodedStream.seekAbsolute(position);
            Parser parser = new Parser(this.m_DecodedStream, 1);
            Object ob = parser.getObject(library);
            if (ob == null) {
                Reference ref = new Reference(objectNumber, 0);
                ob = parser.addPObject(library, ref);
            } else if (!(ob instanceof PObject)) {
                Reference ref = new Reference(objectNumber, 0);
                library.addObject(ob, ref);
            }
            if (ob != null && ob instanceof Dictionary) {
                ((Dictionary)ob).setPObjectReference(new Reference(objectNumber, 0));
            }
            gotSomething = ob != null;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error loading PDF object.", e);
        }
        finally {
            this.m_DecodedStream.endThreadAccess();
        }
        return gotSomething;
    }

    public void dispose(boolean cache) {
        this.m_bInited = false;
        this.m_DecodedStream = null;
        this.m_iaObjectNumbers = null;
        this.m_laObjectOffset = null;
        super.dispose(cache);
    }
}

