/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBeanSelector;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItemBase;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.databeans.TypeTag;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.RequestExecuter;
import fi.csc.microarray.databeans.handlers.DataBeanHandler;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.InputStreamSource;
import fi.csc.microarray.util.StreamStartCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DataBean
extends DataItemBase {
    protected DataManager dataManager;
    protected StreamStartCache streamStartCache = null;
    private HashMap<String, Object> contentCache = new HashMap();
    private URL cacheUrl = null;
    private boolean contentChanged = true;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private LinkedList<LinkedBean> outgoingLinks = new LinkedList();
    private LinkedList<LinkedBean> incomingLinks = new LinkedList();
    private LinkedList<TypeTag> tags = new LinkedList();
    protected Date date;
    private OperationRecord operationRecord;
    private String notes;
    protected ContentType contentType;
    private StorageMethod storageMethod;
    private String repositoryName;
    private URL url;
    private DataBeanHandler handler;

    public DataBean(String name, StorageMethod type, String repositoryName, URL contentUrl, ContentType contentType, Date date, DataBean[] sources, DataFolder parentFolder, DataManager manager, DataBeanHandler handler) {
        this.dataManager = manager;
        this.name = name;
        this.url = contentUrl;
        this.storageMethod = type;
        this.repositoryName = repositoryName;
        this.handler = handler;
        this.date = date;
        this.parent = parentFolder;
        if (parentFolder != null) {
            parentFolder.addChild(this);
        }
        for (DataBean source : sources) {
            source.addLink(Link.DERIVATION, this);
        }
        this.contentType = contentType;
    }

    public OperationRecord getOperationRecord() {
        return this.operationRecord;
    }

    public void setOperationRecord(OperationRecord operationRecord) {
        this.operationRecord = operationRecord;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public boolean isContentTypeCompatitible(String ... alternatives) {
        for (String alternative : alternatives) {
            if (!alternative.toLowerCase().equals(this.getContentType().getType().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public void setName(String newName) {
        super.setName(newName);
        ContentChangedEvent cce = new ContentChangedEvent(this);
        this.dataManager.dispatchEventIfVisible(cce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult queryFeatures(String request) {
        try {
            this.lock.readLock().lock();
            Feature feature = new RequestExecuter(this.dataManager).execute(request, this);
            if (feature == null) {
                throw new UnsupportedOperationException("request " + request + " not possible from " + this.getName());
            }
            QueryResult queryResult = new QueryResult(feature);
            return queryResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public InputStream getContentByteStream() throws IOException {
        return this.getRawContentByteStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContents() throws IOException {
        byte[] byArray = Files.inputStreamToBytes(this.getContentByteStream());
        return byArray;
    }

    public byte[] getContents(long maxLength) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream in = this.getContentByteStream();
        int b = in.read();
        for (long readCount = 0L; b != -1 && readCount < maxLength; ++readCount) {
            outputStream.write(b);
            b = in.read();
        }
        return outputStream.toByteArray();
    }

    public long getContentLength() {
        if (this.handler == null) {
            throw new IllegalStateException("Handler is null.");
        }
        try {
            return this.handler.getContentLength(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this.handler.delete(this);
        this.contentType = null;
    }

    public void putToContentCache(String name, Object value) {
        this.contentCache.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromContentCache(String name) {
        Object object = this.contentCache.get(name);
        return object;
    }

    protected void resetContentCache() {
        this.contentCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseStreamStartCache() throws MicroarrayException, IOException {
        this.streamStartCache = new StreamStartCache(this.getRawContentByteStream(), new InputStreamSource(){

            @Override
            public InputStream getInputStream() {
                try {
                    return DataBean.this.getRawContentByteStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void addLink(Link type, DataBean target) {
        if (target == null) {
            return;
        }
        target.incomingLinks.add(new LinkedBean(type, this));
        this.outgoingLinks.add(new LinkedBean(type, target));
        if (this.getParent() != null && target.getParent() != null) {
            LinksChangedEvent lce = new LinksChangedEvent(this, target, type, true);
            this.dataManager.dispatchEvent(lce);
        }
    }

    public void removeLink(Link type, DataBean target) {
        for (LinkedBean outgoingLink : this.outgoingLinks) {
            if (outgoingLink.bean != target || outgoingLink.link != type) continue;
            this.outgoingLinks.remove(outgoingLink);
            DataBean bean = outgoingLink.bean;
            for (LinkedBean incomingLink : bean.incomingLinks) {
                if (incomingLink.bean != this || incomingLink.link != type) continue;
                bean.incomingLinks.remove(incomingLink);
                LinksChangedEvent lce = new LinksChangedEvent(this, target, type, false);
                this.dataManager.dispatchEventIfVisible(lce);
                return;
            }
        }
        throw new RuntimeException("internal error: failed locate links for: " + this.getName() + " <" + (Object)((Object)type) + "> " + target.getName());
    }

    public List<DataBean> traverseLinks(Link[] types, Traversal traversal) {
        DataBeanSelector acceptAllSelector = new DataBeanSelector(){

            @Override
            public boolean shouldSelect(DataBean bean) {
                return true;
            }

            @Override
            public boolean shouldTraverse(DataBean bean) {
                return true;
            }
        };
        return this.traverseLinks(types, traversal, acceptAllSelector);
    }

    public List<DataBean> traverseLinks(Link[] types, Traversal traversal, DataBeanSelector selector) {
        LinkedHashSet<DataBean> newBeans;
        LinkedList<DataBean> selected = new LinkedList<DataBean>();
        LinkedList<DataBean> traversed = new LinkedList<DataBean>();
        traversed.add(this);
        this.conditionallySelect(selector, selected, this);
        do {
            newBeans = new LinkedHashSet<DataBean>();
            for (DataBean bean : traversed) {
                LinkedHashSet<DataBean> linkedBeans = new LinkedHashSet<DataBean>();
                if (traversal.isDirect()) {
                    for (Link type : types) {
                        linkedBeans.addAll(bean.getLinkTargets(type));
                    }
                }
                if (traversal.isReversed()) {
                    for (Link type : types) {
                        linkedBeans.addAll(bean.getLinkSources(type));
                    }
                }
                for (DataBean linkedBean : linkedBeans) {
                    if (traversed.contains(linkedBean) || !selector.shouldTraverse(linkedBean)) continue;
                    newBeans.add(linkedBean);
                }
            }
            for (DataBean newBean : newBeans) {
                traversed.add(newBean);
                this.conditionallySelect(selector, selected, newBean);
            }
        } while (newBeans.size() > 0);
        return selected;
    }

    public List<DataBean> getLinkTargets(Link ... types) {
        return this.getLinkedBeans(types, this.outgoingLinks);
    }

    public List<DataBean> getLinkSources(Link ... types) {
        return this.getLinkedBeans(types, this.incomingLinks);
    }

    public void addTypeTag(TypeTag tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTypeTag(TypeTag tag) {
        this.tags.remove(tag);
    }

    public List<TypeTag> getTypeTags() {
        return this.tags;
    }

    public boolean hasTypeTag(TypeTag ... alternativeTags) {
        for (TypeTag alternativeTag : alternativeTags) {
            if (!this.tags.contains(alternativeTag)) continue;
            return true;
        }
        return false;
    }

    public URL getContentUrl() {
        return this.url;
    }

    public void setContentUrl(URL contentUrl) {
        this.url = contentUrl;
    }

    public DataBeanHandler getHandler() {
        return this.handler;
    }

    public void setHandler(DataBeanHandler handler) {
        this.handler = handler;
    }

    public StorageMethod getStorageMethod() {
        return this.storageMethod;
    }

    public void setStorageMethod(StorageMethod storageMethod) {
        this.storageMethod = storageMethod;
    }

    public String getRepositoryName() {
        if (this.repositoryName == null) {
            return "";
        }
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public void setContentChanged(boolean contentChanged) {
        this.contentChanged = contentChanged;
    }

    public URL getCacheUrl() {
        return this.cacheUrl;
    }

    public void setCacheUrl(URL url) {
        this.cacheUrl = url;
    }

    public void setCreationDate(Date date) {
        this.date = date;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public String toString() {
        return this.getName();
    }

    public DataBean getUniqueAncestorRecursively(DataBean dataBean) {
        if (dataBean.getLinkTargets(Link.derivationalTypes()).size() != 1) {
            return dataBean;
        }
        return this.getUniqueAncestorRecursively(dataBean.getLinkTargets(Link.derivationalTypes()).get(0));
    }

    private void conditionallySelect(DataBeanSelector selector, LinkedList<DataBean> selected, DataBean bean) {
        if (!selected.contains(bean) && selector.shouldSelect(bean)) {
            selected.add(bean);
        }
    }

    private List<DataBean> getLinkedBeans(Link[] types, LinkedList<LinkedBean> links) {
        LinkedList<DataBean> targets = new LinkedList<DataBean>();
        block0: for (LinkedBean linkTarget : links) {
            for (Link type : types) {
                if (linkTarget.link != type) continue;
                targets.add(linkTarget.bean);
                continue block0;
            }
        }
        return targets;
    }

    private InputStream getRawContentByteStream() throws IOException {
        if (this.handler == null) {
            throw new IllegalStateException("Handler is null.");
        }
        return this.handler.getInputStream(this);
    }

    private static class LinkedBean {
        Link link;
        DataBean bean;

        LinkedBean(Link link, DataBean bean) {
            this.link = link;
            this.bean = bean;
        }
    }

    public static enum Link {
        ANNOTATION("Annotation"),
        DERIVATION("Derivation"),
        MODIFICATION("Modification"),
        GROUPING("Grouping");

        private String name;

        private Link(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Link[] userEditableValues() {
            return new Link[]{ANNOTATION, DERIVATION, MODIFICATION};
        }

        public static Link[] derivationalTypes() {
            return new Link[]{DERIVATION, MODIFICATION};
        }
    }

    public static enum Traversal {
        DIRECT,
        REVERSED,
        BIDIRECTIONAL;


        public boolean isDirect() {
            return this == DIRECT || this == BIDIRECTIONAL;
        }

        public boolean isReversed() {
            return this == REVERSED || this == BIDIRECTIONAL;
        }
    }

    public static enum StorageMethod {
        LOCAL_USER,
        LOCAL_TEMP,
        LOCAL_SESSION;

    }
}

