/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;

public class HeaderTsvParser
extends TsvParser {
    public HeaderTsvParser() {
        super(new FileDefinition((Collection<ColumnDefinition>)Arrays.asList(new ColumnDefinition(ColumnType.CHROMOSOME, Type.STRING), new ColumnDefinition(ColumnType.BP_START, Type.LONG), new ColumnDefinition(ColumnType.BP_END, Type.LONG), new ColumnDefinition(ColumnType.SKIP, Type.STRING), new ColumnDefinition(ColumnType.SKIP, Type.STRING), new ColumnDefinition(ColumnType.SKIP, Type.STRING), new ColumnDefinition(ColumnType.SKIP, Type.STRING))));
    }

    public HeaderTsvParser(FileDefinition fileDefinition) {
        super(fileDefinition);
    }

    @Override
    public String getName() {
        return "Chipster peaks";
    }

    @Override
    public long getDefaulChunkLength() {
        return 128L;
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        return new RegionContent[0];
    }

    @Override
    public Object get(String[] cols, ColumnType col) {
        Object obj = super.get(cols, col);
        if (col == ColumnType.CHROMOSOME) {
            return new Chromosome(((Chromosome)obj).toString().replace(".fa", ""));
        }
        return obj;
    }

    @Override
    public long getHeaderLength(File file) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String firstLine = in.readLine();
        return (firstLine + "\n").length();
    }
}

