/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.gbrowser;

import fi.csc.chipster.tools.gbrowser.ChromosomeNormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.HeaderTsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class TsvSorter {
    private TsvParser parser;
    private int chrCol;
    private int bpCol;
    private ChromosomeNormaliser chromosomeNormaliser = new ChromosomeNormaliser(){

        @Override
        public String normaliseChromosome(String chromosomeName) {
            return chromosomeName.replace("chr", "").replace(".fa", "");
        }
    };

    public void sort(File in, File out, TsvParser parser) throws Exception {
        this.parser = parser;
        this.chrCol = parser.getFileDefinition().indexOf(ColumnType.CHROMOSOME);
        this.bpCol = parser.getFileDefinition().indexOf(ColumnType.BP_START);
        this.externalSort(in, out);
    }

    public void sort(File in, File out, TsvParser parser, ChromosomeNormaliser chromosomeNormaliser) throws Exception {
        this.chromosomeNormaliser = chromosomeNormaliser;
        this.sort(in, out, parser);
    }

    private void externalSort(File infile, File outfile) throws IOException, MicroarrayException {
        BufferedReader initReader = new BufferedReader(new FileReader(infile));
        String headerRow = null;
        if (this.parser.getHeaderLength(infile) > 0L) {
            headerRow = initReader.readLine();
        }
        ArrayList<Row> rowBatch = new ArrayList<Row>(500000);
        boolean quit = false;
        int numFiles = 0;
        while (!quit) {
            String line;
            for (int size = 0; size < 200000000; size += line.length()) {
                line = initReader.readLine();
                if (line == null) {
                    quit = true;
                    break;
                }
                rowBatch.add(new Row(line));
            }
            Collections.sort(rowBatch);
            FileWriter fw = new FileWriter(infile + "_chunk" + numFiles);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < rowBatch.size(); ++i) {
                bw.append(((Row)rowBatch.get((int)i)).line + "\n");
            }
            bw.close();
            ++numFiles;
            rowBatch.clear();
        }
        this.mergeFiles(infile.getAbsolutePath(), outfile, numFiles, headerRow);
        initReader.close();
    }

    private void mergeFiles(String inputFilePath, File outputFilePath, int numChunkFiles, String headerRow) throws IOException, MicroarrayException {
        int i;
        ArrayList<BufferedReader> mergefbr = new ArrayList<BufferedReader>();
        ArrayList<Row> filerows = new ArrayList<Row>();
        FileWriter fw = new FileWriter(outputFilePath);
        BufferedWriter bw = new BufferedWriter(fw);
        if (headerRow != null) {
            bw.append(headerRow + "\n");
        }
        boolean someFileStillHasRows = false;
        for (int i2 = 0; i2 < numChunkFiles; ++i2) {
            mergefbr.add(new BufferedReader(new FileReader(inputFilePath + "_chunk" + i2)));
            String line = ((BufferedReader)mergefbr.get(i2)).readLine();
            if (line != null) {
                filerows.add(new Row(line));
                someFileStillHasRows = true;
                continue;
            }
            filerows.add(null);
        }
        while (someFileStillHasRows) {
            int i3;
            Row min;
            int minIndex = 0;
            Row row = (Row)filerows.get(0);
            if (row != null) {
                min = row;
                minIndex = 0;
            } else {
                min = null;
                minIndex = -1;
            }
            for (i3 = 1; i3 < filerows.size(); ++i3) {
                row = (Row)filerows.get(i3);
                if (min != null) {
                    if (row == null || row.compareTo(min) >= 0) continue;
                    minIndex = i3;
                    min = (Row)filerows.get(i3);
                    continue;
                }
                if (row == null) continue;
                min = row;
                minIndex = i3;
            }
            if (minIndex < 0) {
                someFileStillHasRows = false;
            } else {
                bw.append(((Row)filerows.get((int)minIndex)).line + "\n");
                String line = ((BufferedReader)mergefbr.get(minIndex)).readLine();
                if (line != null) {
                    filerows.set(minIndex, new Row(line));
                } else {
                    filerows.set(minIndex, null);
                }
            }
            for (i3 = 0; i3 < filerows.size(); ++i3) {
                someFileStillHasRows = false;
                if (filerows.get(i3) == null) continue;
                if (minIndex < 0) {
                    throw new MicroarrayException("Error in sorting: mindex lt 0 and found row not null" + filerows.get(i3));
                }
                someFileStillHasRows = true;
                break;
            }
            if (someFileStillHasRows) continue;
            for (i3 = 0; i3 < filerows.size(); ++i3) {
                String line;
                if (filerows.get(i3) != null || (line = ((BufferedReader)mergefbr.get(i3)).readLine()) == null) continue;
                someFileStillHasRows = true;
                filerows.set(i3, new Row(line));
            }
        }
        bw.close();
        fw.close();
        for (i = 0; i < mergefbr.size(); ++i) {
            ((BufferedReader)mergefbr.get(i)).close();
        }
        for (i = 0; i < numChunkFiles; ++i) {
            File f = new File(inputFilePath + "_chunk" + i);
            f.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        String filename = "/home/akallio/Desktop/cisREDgroup_contents_for_40193-STAT1_trimmed.tsv";
        String resultFilename = filename + ".sorted";
        new TsvSorter().sort(new File(filename), new File(resultFilename), new HeaderTsvParser());
    }

    private class Row
    extends BpCoord {
        public String line;

        public Row(String line) {
            String chrStr;
            super(null, null);
            this.line = line;
            String[] splitted = line.split("\t");
            String string = chrStr = splitted.length > TsvSorter.this.chrCol ? splitted[TsvSorter.this.chrCol] : "";
            if (!"".equals(chrStr)) {
                splitted[((TsvSorter)TsvSorter.this).chrCol] = chrStr = TsvSorter.this.chromosomeNormaliser.normaliseChromosome(chrStr);
                this.line = Strings.delimit(Arrays.asList(splitted), "\t");
            }
            String bpStr = splitted.length > TsvSorter.this.bpCol ? splitted[TsvSorter.this.bpCol] : "";
            this.chr = new Chromosome(chrStr);
            this.bp = bpStr.equals("") ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(bpStr));
        }
    }
}

