/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;

public class Currency
extends MeasureUnit
implements Serializable {
    private static final long serialVersionUID = -5839973855554750484L;
    private static final boolean DEBUG = ICUDebug.enabled("currency");
    private String isoCode;
    public static final int SYMBOL_NAME = 0;
    public static final int LONG_NAME = 1;
    private static ServiceShim shim;
    private static final String EUR_STR = "EUR";
    private static final int[] LAST_RESORT_DATA;
    private static final int[] POW10;
    private ULocale validLocale;
    private ULocale actualLocale;

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.icu.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static Currency getInstance(Locale locale) {
        return Currency.getInstance(ULocale.forLocale(locale));
    }

    public static Currency getInstance(ULocale locale) {
        String currency = locale.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    public static String[] getAvailableCurrencyCodes(ULocale loc, Date d) {
        String country = loc.getCountry();
        long dateL = d.getTime();
        long mask = 0xFFFFFFFFL;
        Vector<String> currCodeVector = new Vector<String>();
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (bundle == null) {
            return null;
        }
        try {
            UResourceBundle cm = bundle.get("CurrencyMap");
            UResourceBundle countryArray = cm.get(country);
            for (int i = 0; i < countryArray.getSize(); ++i) {
                UResourceBundle currencyReq = countryArray.get(i);
                String curriso = null;
                curriso = currencyReq.getString("id");
                long fromDate = 0L;
                UResourceBundle fromRes = currencyReq.get("from");
                int[] fromArray = fromRes.getIntVector();
                fromDate = (long)fromArray[0] << 32;
                fromDate |= (long)fromArray[1] & mask;
                if (currencyReq.getSize() > 2) {
                    long toDate = 0L;
                    UResourceBundle toRes = currencyReq.get("to");
                    int[] toArray = toRes.getIntVector();
                    toDate = (long)toArray[0] << 32;
                    if (fromDate > dateL || dateL >= (toDate |= (long)toArray[1] & mask)) continue;
                    currCodeVector.addElement(curriso);
                    continue;
                }
                if (fromDate > dateL) continue;
                currCodeVector.addElement(curriso);
            }
            currCodeVector.trimToSize();
            if (currCodeVector.size() != 0) {
                return currCodeVector.toArray(new String[0]);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return null;
    }

    static Currency createCurrency(ULocale loc) {
        String country = loc.getCountry();
        String variant = loc.getVariant();
        boolean isPreEuro = variant.equals("PREEURO");
        boolean isEuro = variant.equals("EURO");
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (bundle == null) {
            return null;
        }
        try {
            UResourceBundle cm = bundle.get("CurrencyMap");
            String curriso = null;
            UResourceBundle countryArray = cm.get(country);
            UResourceBundle currencyReq = countryArray.get(0);
            curriso = currencyReq.getString("id");
            if (isPreEuro && curriso.equals(EUR_STR)) {
                currencyReq = countryArray.get(1);
                curriso = currencyReq.getString("id");
            } else if (isEuro) {
                curriso = EUR_STR;
            }
            if (curriso != null) {
                return new Currency(curriso);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return null;
    }

    public static Currency getInstance(String theISOCode) {
        if (theISOCode == null) {
            throw new NullPointerException("The input currency code is null.");
        }
        boolean is3alpha = true;
        if (theISOCode.length() != 3) {
            is3alpha = false;
        } else {
            for (int i = 0; i < 3; ++i) {
                char ch = theISOCode.charAt(i);
                if (ch >= 'A' && (ch <= 'Z' || ch >= 'a') && ch <= 'z') continue;
                is3alpha = false;
                break;
            }
        }
        if (!is3alpha) {
            throw new IllegalArgumentException("The input currency code is not 3-letter alphabetic code.");
        }
        return new Currency(theISOCode.toUpperCase(Locale.US));
    }

    public static Object registerInstance(Currency currency, ULocale locale) {
        return Currency.getShim().registerInstance(currency, locale);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt40b");
        }
        return shim.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt40b");
        }
        return shim.getAvailableULocales();
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            Currency c = (Currency)rhs;
            return this.isoCode.equals(c.isoCode);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getSymbol() {
        return this.getSymbol(ULocale.getDefault());
    }

    public String getSymbol(Locale loc) {
        return this.getSymbol(ULocale.forLocale(loc));
    }

    public String getSymbol(ULocale uloc) {
        return this.getName(uloc, 0, new boolean[1]);
    }

    public String getName(Locale locale, int nameStyle, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, isChoiceFormat);
    }

    public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle < 0 || nameStyle > 1) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", locale);
            ICUResourceBundle currencies = (ICUResourceBundle)rb.get("Currencies");
            s = currencies.getWithFallback(this.isoCode).getString(nameStyle);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        isChoiceFormat[0] = false;
        if (s != null) {
            int i;
            for (i = 0; i < s.length() && s.charAt(i) == '=' && i < 2; ++i) {
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                s = s.substring(1);
            }
            return s;
        }
        return this.isoCode;
    }

    public static String parse(ULocale locale, String text, ParsePosition pos) {
        int start = pos.getIndex();
        String fragment = text.substring(start);
        String iso = null;
        int max = 0;
        while (locale != null) {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", locale);
            try {
                UResourceBundle currencies = rb.get("Currencies");
                for (int i = 0; i < currencies.getSize(); ++i) {
                    UResourceBundle item = currencies.get(i);
                    String name = item.getString(0);
                    if (name.length() < 1) continue;
                    if (name.charAt(0) == '=' && (name = name.substring(1)).length() > 0 && name.charAt(0) != '=') {
                        ChoiceFormat choice = new ChoiceFormat(name);
                        choice.parse(text, pos);
                        int len = pos.getIndex() - start;
                        if (len > max) {
                            iso = item.getKey();
                            max = len;
                        }
                        pos.setIndex(start);
                        continue;
                    }
                    if (name.length() <= max || !fragment.startsWith(name)) continue;
                    iso = item.getKey();
                    max = name.length();
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            locale = locale.getFallback();
        }
        if (max < 3 && text.length() - start >= 3) {
            boolean valid = true;
            for (int k = 0; k < 3; ++k) {
                char ch = text.charAt(start + k);
                if (ch >= 'A' && ch <= 'Z') continue;
                valid = false;
                break;
            }
            if (valid) {
                iso = text.substring(start, start + 3);
                max = 3;
            }
        }
        pos.setIndex(start + max);
        return iso;
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        int[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    protected Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private int[] findData() {
        try {
            UResourceBundle root = ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle currencyMeta = root.get("CurrencyMeta");
            int[] i = currencyMeta.get(this.isoCode).getIntVector();
            if (i == null) {
                i = currencyMeta.get("DEFAULT").getIntVector();
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return LAST_RESORT_DATA;
    }

    public final ULocale getLocale(ULocale.Type type) {
        ULocale result;
        ULocale uLocale = result = type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
        if (result == null) {
            return ULocale.ROOT;
        }
        return result;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static {
        LAST_RESORT_DATA = new int[]{2, 0};
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract ULocale[] getAvailableULocales();

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(ULocale var1);

        abstract Object registerInstance(Currency var1, ULocale var2);

        abstract boolean unregister(Object var1);
    }
}

