/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends HandlerWrapper
implements Attributes {
    private static final String _version = Server.class.getPackage() != null && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : System.getProperty("jetty.version", "7.x.y-SNAPSHOT");
    private final Container _container = new Container();
    private final AttributesMap _attributes = new AttributesMap();
    private final List<Object> _dependentBeans = new ArrayList<Object>();
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private SessionIdManager _sessionIdManager;
    private boolean _sendServerVersion = true;
    private boolean _sendDateHeader = false;
    private int _graceful = 0;
    private boolean _stopAtShutdown;
    private int _maxCookieVersion = 1;

    public Server() {
        this.setServer(this);
    }

    public Server(int port) {
        this.setServer(this);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        this.setConnectors(new Connector[]{connector});
    }

    public Server(InetSocketAddress addr) {
        this.setServer(this);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(addr.getHostName());
        connector.setPort(addr.getPort());
        this.setConnectors(new Connector[]{connector});
    }

    public static String getVersion() {
        return _version;
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return this._stopAtShutdown;
    }

    public void setStopAtShutdown(boolean stop) {
        this._stopAtShutdown = stop;
        if (stop) {
            ShutdownThread.register(this);
        } else {
            ShutdownThread.deregister(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.addToArray(this.getConnectors(), connector, Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.removeFromArray(this.getConnectors(), connector));
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
        this._container.update((Object)this, this._connectors, connectors, "connector");
        this._connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool", true);
        this._threadPool = threadPool;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getStopAtShutdown()) {
            ShutdownThread.register(this);
        }
        Log.info("jetty-" + _version);
        HttpGenerator.setServerVersion(_version);
        MultiException mex = new MultiException();
        if (this._threadPool == null) {
            QueuedThreadPool tp = new QueuedThreadPool();
            this.setThreadPool(tp);
        }
        Iterator<Object> itor = this._dependentBeans.iterator();
        while (itor.hasNext()) {
            try {
                Object o = itor.next();
                if (!(o instanceof LifeCycle)) continue;
                ((LifeCycle)o).start();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.start();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).start();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            Log.warn("Error starting handlers", e);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (Log.isDebugEnabled()) {
            System.err.println(this.dump());
        }
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        if (this._graceful > 0) {
            if (this._connectors != null) {
                int i = this._connectors.length;
                while (i-- > 0) {
                    Log.info("Graceful shutdown {}", this._connectors[i]);
                    try {
                        this._connectors[i].close();
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                }
            }
            Handler[] contexts = this.getChildHandlersByClass(Graceful.class);
            for (int c = 0; c < contexts.length; ++c) {
                Graceful context = (Graceful)contexts[c];
                Log.info("Graceful shutdown {}", context);
                context.setShutdown(true);
            }
            Thread.sleep(this._graceful);
        }
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.stop();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (!this._dependentBeans.isEmpty()) {
            ListIterator<Object> itor = this._dependentBeans.listIterator(this._dependentBeans.size());
            while (itor.hasPrevious()) {
                try {
                    Object o = itor.previous();
                    if (!(o instanceof LifeCycle)) continue;
                    ((LifeCycle)o).stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
        if (this.getStopAtShutdown()) {
            ShutdownThread.deregister(this);
        }
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        Request request = connection.getRequest();
        Response response = connection.getResponse();
        if (Log.isDebugEnabled()) {
            Log.debug("REQUEST " + target + " on " + connection);
            this.handle(target, request, request, response);
            Log.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus());
        } else {
            this.handle(target, request, request, response);
        }
    }

    public void handleAsync(HttpConnection connection) throws IOException, ServletException {
        AsyncContinuation async = connection.getRequest().getAsyncContinuation();
        AsyncContinuation.AsyncEventState state = async.getAsyncEventState();
        Request baseRequest = connection.getRequest();
        String path = state.getPath();
        if (path != null) {
            baseRequest.setAttribute("javax.servlet.async.request_uri", baseRequest.getRequestURI());
            baseRequest.setAttribute("javax.servlet.async.query_string", baseRequest.getQueryString());
            baseRequest.setAttribute("javax.servlet.async.context_path", state.getSuspendedContext().getContextPath());
            String contextPath = state.getServletContext().getContextPath();
            HttpURI uri = new HttpURI(URIUtil.addPaths(contextPath, path));
            baseRequest.setUri(uri);
            baseRequest.setRequestURI(null);
            baseRequest.setPathInfo(baseRequest.getRequestURI());
            baseRequest.setQueryString(uri.getQuery());
        }
        String target = baseRequest.getPathInfo();
        HttpServletRequest request = (HttpServletRequest)async.getRequest();
        HttpServletResponse response = (HttpServletResponse)async.getResponse();
        if (Log.isDebugEnabled()) {
            Log.debug("REQUEST " + target + " on " + connection);
            this.handle(target, baseRequest, request, response);
            Log.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus());
        } else {
            this.handle(target, baseRequest, request, response);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._container.update((Object)this, this._sessionIdManager, sessionIdManager, "sessionIdManager", true);
        this._sessionIdManager = sessionIdManager;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this._sendDateHeader = sendDateHeader;
    }

    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public int getMaxCookieVersion() {
        return this._maxCookieVersion;
    }

    public void setMaxCookieVersion(int maxCookieVersion) {
        this._maxCookieVersion = maxCookieVersion;
    }

    @Deprecated
    public void addLifeCycle(LifeCycle c) {
        this.addBean(c);
    }

    public void addBean(Object o) {
        if (o == null) {
            return;
        }
        if (!this._dependentBeans.contains(o)) {
            this._dependentBeans.add(o);
            this._container.addBean(o);
        }
        try {
            if (this.isStarted() && o instanceof LifeCycle) {
                ((LifeCycle)o).start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Object o : this._dependentBeans) {
            if (!clazz.isInstance(o)) continue;
            beans.add(o);
        }
        return beans;
    }

    public <T> T getBean(Class<T> clazz) {
        Iterator<Object> iter = this._dependentBeans.iterator();
        Object t = null;
        int count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!clazz.isInstance(o)) continue;
            ++count;
            if (t != null) continue;
            t = o;
        }
        if (count > 1) {
            Log.debug("getBean({}) 1 of {}", clazz.getName(), count);
        }
        return (T)t;
    }

    @Deprecated
    public void removeLifeCycle(LifeCycle c) {
        this.removeBean(c);
    }

    public void removeBean(Object o) {
        if (o == null) {
            return;
        }
        this._dependentBeans.remove(o);
        this._container.removeBean(o);
    }

    @Override
    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    @Override
    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public int getGracefulShutdown() {
        return this._graceful;
    }

    public void setGracefulShutdown(int timeoutMS) {
        this._graceful = timeoutMS;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public static void main(String[] args) {
        System.err.println(Server.getVersion());
    }

    public static interface Graceful
    extends Handler {
        public void setShutdown(boolean var1);
    }
}

