/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;

public class TestASTConstruction
extends BaseTest {
    public void testA() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT A <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakeRulePlusInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : B+;\nB : 'a';");
        String string = " ( rule A ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT B <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"A").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRulePlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (b)+;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakedRulePlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b+;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (b)?;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakedRuleOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b?;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testRuleStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (b)*;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testNakedRuleStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b*;\nb : B;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharStar() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a'*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharStarInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'b'*;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testStringStar() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'while'*;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'while' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testStringStarInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'while'*;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'while' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharPlus() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a'+;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharPlusInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'b'+;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharOptional() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a'?;");
        String string = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharOptionalInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'b'?;");
        String string = " ( rule B ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }

    public void testCharRangePlus() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nID : 'a'..'z'+;");
        String string = " ( rule ID ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT ( .. 'a' 'z' ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String string2 = grammar.getRule((String)"ID").tree.toStringTree();
        TestASTConstruction.assertEquals((String)string, (String)string2);
    }
}

