

package org.jfree.data.som.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.LinkedList;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.som.SOMDataItem;

/**
 * Tests for the {@link org.jfree.data.general.PieDataset} class.
 */
public class SOMDataItemTests extends TestCase {

    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(SOMDataItemTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public SOMDataItemTests(String name) {
        super(name);
    }

    public void testGetSetColor() {
        SOMDataItem i1 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
                
        assertTrue(i1.getColor().equals(Color.red));
        i1.setColor(Color.black);
        assertTrue(i1.getColor().equals(Color.black));
        try {
            i1.setColor(null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }
    
    public void testGetSetDescription() {
        SOMDataItem i1 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
                
        assertTrue(Arrays.equals(i1.getDescriptions(),
                new String[] {new String("qazxsw"), new String("6767")}));
        i1.setDescriptions(
                new String[] {new String("A"), new String("B"), new String("C")});
        assertTrue(Arrays.equals(i1.getDescriptions(),
                new String[] {new String("A"), new String("B"), new String("C")}));
        assertFalse(Arrays.equals(i1.getDescriptions(),
                new String[] {new String("qazxsw"), new String("6767")}));
        assertFalse(Arrays.equals(i1.getDescriptions(),
                new String[] {null, new String("6767")}));
        assertFalse(Arrays.equals(i1.getDescriptions(),
                new String[] {new String("qazxsw"), null}));
        try {
            i1.setDescriptions(null);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(true);
        }
    }
    
    public void testGetSetNeuronWeights() {
        SOMDataItem i1 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
                
        assertTrue(Arrays.equals(i1.getNeuronWeights(),
                new double[] {2.0, 0.9}));
        i1.setNeuronWeights(
                new double[] {2.0, 0.9});
        assertTrue(Arrays.equals(i1.getNeuronWeights(),
                new double[] {2.0, 0.9}));
        assertFalse(Arrays.equals(i1.getNeuronWeights(),
                new double[] {2.0, 0.9, 44444.2}));
        assertFalse(Arrays.equals(i1.getNeuronWeights(),
                new double[] {0.9}));
        assertFalse(Arrays.equals(i1.getNeuronWeights(),
                new double[] {}));
        try {
            i1.setNeuronWeights(null);
            assertTrue(false);
        } catch (NullPointerException e) {
        }
    }
    
    public void testEquals() {
        SOMDataItem i1 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
        SOMDataItem i2 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
        SOMDataItem i3 = new SOMDataItem(Color.red, 
                new String[] {new String("ZZZazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
        SOMDataItem i4 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("ZZZZ767")}, 
                new double[] {2.0, 0.9});
        SOMDataItem i5 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {111111111.0, 0.9});
        SOMDataItem i6 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 111111111.9});
        SOMDataItem i7 = new SOMDataItem(Color.red, 
                new String[] {null, new String("6767")}, 
                new double[] {2.0, 0.9});
        SOMDataItem i8 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0});
        SOMDataItem i9 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), null}, 
                new double[] {2.0, 0.9});
        SOMDataItem i10 = new SOMDataItem(Color.red, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9, 212121.1});
        SOMDataItem i11 = new SOMDataItem(Color.blue, 
                new String[] {new String("qazxsw"), new String("6767")}, 
                new double[] {2.0, 0.9});
        SOMDataItem i12 = new SOMDataItem(Color.blue, 
                new String[] {new String("qazxsw"), null}, 
                new double[] {2.0, 0.9});
        SOMDataItem i13 = new SOMDataItem(Color.blue, 
                new String[] {new String("qazxsw"), null}, 
                new double[] {2.0, 0.9});
        
        assertTrue(i1.equals(i2));
        assertFalse(i1.equals(i3));
        assertFalse(i1.equals(i4));
        assertFalse(i1.equals(i5));
        assertFalse(i1.equals(i6));
        assertFalse(i1.equals(i7));
        assertFalse(i1.equals(i8));
        assertFalse(i1.equals(i9));
        assertFalse(i1.equals(i10));
        assertFalse(i1.equals(i11));
        
        assertTrue(i12.equals(i13));
        
        assertTrue(i1.equals(i1));
        assertFalse(i1.equals(new LinkedList()));
        i2.setSelected(true);
        assertFalse(i1.equals(i2));
    }
    
    /**
     * Confirm that cloning works.
     */
    public void testCloning() {
        String[] s = {new String("qazxsw"), new String("6767")};
        double[] d = {2.0, 0.9};
        SOMDataItem i1 = new SOMDataItem(Color.red, s, d);
        SOMDataItem i2 = null;
        try {
            i2 = (SOMDataItem) i1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        assertTrue(i1 != i2);
        assertTrue(i1.getClass() == i2.getClass());
        assertTrue(i1.equals(i2));
    }

    /**
     * Serialize an instance, restore it, and check for equality.
     */
    public void testSerialization() {

        String[] s = {new String("qazxsw"), new String("6767")};
        double[] d = {2.0, 0.9};
        SOMDataItem i1 = new SOMDataItem(Color.red, s, d);

        SOMDataItem i2 = null;

        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutput out = new ObjectOutputStream(buffer);
            out.writeObject(i1);
            out.close();

            ObjectInput in = new ObjectInputStream(
                new ByteArrayInputStream(buffer.toByteArray())
            );
            i2 = (SOMDataItem) in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        assertEquals(i1, i2);

    }

}
