/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.Traceable;

public class LogProcessor
implements Processor,
Traceable {
    private final Expression expression;
    private final Logger logger;

    public LogProcessor(Expression expression, Logger logger) {
        this.expression = expression;
        this.logger = logger;
    }

    public void process(Exchange exchange) throws Exception {
        String msg = this.expression.evaluate(exchange, String.class);
        this.logger.log(msg);
    }

    public String toString() {
        return "Log[" + this.expression + "]";
    }

    public String getTraceLabel() {
        return "log[" + this.expression + "]";
    }
}

