/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.broad.tribble.util.ftp.FTPClient;
import org.broad.tribble.util.ftp.FTPReply;
import org.junit.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FTPClientTest {
    static String host = "ftp.broadinstitute.org";
    static String file = "/pub/igv/TEST/test.txt";
    static int fileSize = 27;
    static byte[] expectedBytes = "abcdefghijklmnopqrstuvwxyz\n".getBytes();
    FTPClient client;

    @BeforeMethod
    public void setUp() throws IOException {
        this.client = new FTPClient();
        FTPReply reply = this.client.connect(host);
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
    }

    @AfterMethod
    public void tearDown() {
        System.out.println("Disconnecting");
        this.client.disconnect();
    }

    @Test
    public void testLogin() throws Exception {
    }

    @Test
    public void testPasv() throws Exception {
        try {
            FTPReply reply = this.client.login("anonymous", "igv@broadinstitute.org");
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            reply = this.client.pasv();
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        }
        finally {
            this.client.closeDataStream();
        }
    }

    @Test
    public void testSize() throws Exception {
        FTPReply reply = this.client.login("anonymous", "igv@broadinstitute.org");
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        reply = this.client.binary();
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        reply = this.client.size(file);
        String val = reply.getReplyString();
        int size = Integer.parseInt(val);
        Assert.assertEquals((long)fileSize, (long)size);
    }

    @Test
    public void testDownload() throws Exception {
        try {
            int b;
            FTPReply reply = this.client.login("anonymous", "igv@broadinstitute.org");
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            reply = this.client.binary();
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            reply = this.client.pasv();
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            reply = this.client.retr(file);
            junit.framework.Assert.assertTrue((reply.getCode() == 150 ? 1 : 0) != 0);
            InputStream is = this.client.getDataStream();
            int idx = 0;
            while ((b = is.read()) >= 0) {
                Assert.assertEquals((long)expectedBytes[idx], (long)((byte)b));
                ++idx;
            }
        }
        finally {
            this.client.closeDataStream();
            FTPReply reply = this.client.retr(file);
            System.out.println(reply.getCode());
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        }
    }

    @Test
    public void testRest() throws Exception {
        try {
            int b;
            FTPReply reply = this.client.login("anonymous", "igv@broadinstitute.org");
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            reply = this.client.binary();
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            reply = this.client.pasv();
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            int restPosition = 5;
            this.client.setRestPosition(5L);
            reply = this.client.retr(file);
            junit.framework.Assert.assertTrue((reply.getCode() == 150 ? 1 : 0) != 0);
            InputStream is = this.client.getDataStream();
            int idx = 5;
            while ((b = is.read()) >= 0) {
                Assert.assertEquals((long)expectedBytes[idx], (long)((byte)b));
                ++idx;
            }
        }
        finally {
            this.client.closeDataStream();
            FTPReply reply = this.client.retr(file);
            System.out.println(reply.getCode());
            junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        }
    }

    @Test
    public void testNonExistentFile() throws Exception {
        String host = "ftp.broadinstitute.org";
        String file = "/pub/igv/TEST/fileDoesntExist.txt";
        FTPClient client = new FTPClient();
        FTPReply reply = client.connect(host);
        Assert.assertTrue((boolean)reply.isSuccess());
        reply = client.login("anonymous", "igv@broadinstitute.org");
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        reply = client.binary();
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        reply = client.executeCommand("size " + file);
        Assert.assertEquals((long)550L, (long)reply.getCode());
        client.disconnect();
    }

    @Test
    public void testNonExistentServer() throws Exception {
        String host = "ftp.noSuchServer.org";
        String file = "/pub/igv/TEST/fileDoesntExist.txt";
        FTPClient client = new FTPClient();
        FTPReply reply = null;
        try {
            reply = client.connect(host);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        client.disconnect();
    }

    @Test
    public void testMultiplePasv() throws Exception {
        FTPReply reply = this.client.login("anonymous", "igv@broadinstitute.org");
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        reply = this.client.pasv();
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        this.client.closeDataStream();
        reply = this.client.pasv();
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        this.client.closeDataStream();
    }

    @Test
    public void testMultipleRest() throws Exception {
        FTPReply reply = this.client.login("anonymous", "igv@broadinstitute.org");
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        reply = this.client.binary();
        junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
        this.restRetr(5, 10);
        this.restRetr(2, 10);
        this.restRetr(15, 10);
    }

    private void restRetr(int restPosition, int length) throws IOException {
        try {
            FTPReply reply;
            if (this.client.getDataStream() == null) {
                reply = this.client.pasv();
                junit.framework.Assert.assertTrue((boolean)reply.isSuccess());
            }
            this.client.setRestPosition(restPosition);
            reply = this.client.retr(file);
            InputStream is = this.client.getDataStream();
            byte[] buffer = new byte[length];
            is.read(buffer);
            int i = 0;
            while (i < length) {
                System.out.print((char)buffer[i]);
                Assert.assertEquals((long)expectedBytes[i + restPosition], (long)buffer[i]);
                ++i;
            }
            System.out.println();
        }
        finally {
            this.client.closeDataStream();
            FTPReply reply = this.client.getReply();
            System.out.println(reply.getReplyString());
        }
    }
}

