/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FilesTest {
    private File testRoot;
    private File dir_1;
    private File dir_2;

    @BeforeTest
    public void setUp() throws IOException {
        this.testRoot = File.createTempFile("deltree-test-", "");
        this.testRoot.delete();
        Assert.assertTrue((boolean)this.testRoot.mkdir());
        System.out.println("created test root dir: " + this.testRoot.getAbsolutePath());
        this.dir_1 = this.createDirWithFiles(this.testRoot, "dir_1", 2);
        this.dir_2 = this.createDirWithFiles(this.testRoot, "dir_2", 3);
        Files.createSymbolicLink(new File(this.dir_1, "file1"), new File(this.dir_1, "fileLink"));
        Files.createSymbolicLink(this.dir_2, new File(this.dir_1, "dirLink"));
    }

    @AfterTest
    public void tearDown() {
        this.testRoot.delete();
    }

    @Test
    public void testDelTree() throws IOException {
        File dir = new File(this.testRoot, "dir");
        dir.mkdir();
        Assert.assertTrue((boolean)Files.delTree(dir));
        Assert.assertFalse((boolean)dir.exists());
        File file = new File(this.testRoot, "file");
        file.createNewFile();
        Assert.assertTrue((boolean)Files.delTree(file));
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)Files.delTree(this.dir_1));
        Assert.assertFalse((boolean)this.dir_1.exists());
        Assert.assertTrue((boolean)Files.delTree(this.dir_2));
        Assert.assertFalse((boolean)this.dir_2.exists());
    }

    private File createDirWithFiles(File parentDir, String dirName, int depth) throws IOException {
        File dir = new File(parentDir, dirName);
        dir.mkdir();
        File file_1 = new File(dir, "file_1");
        file_1.createNewFile();
        File file_2 = new File(dir, "file_2");
        file_2.createNewFile();
        if (depth > 0) {
            this.createDirWithFiles(dir, "dir", --depth);
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        FilesTest t = new FilesTest();
        try {
            t.setUp();
            t.testDelTree();
        }
        finally {
            t.tearDown();
        }
    }
}

