/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;

public class ChipsterInputTypes {
    public static final SADLSyntax.InputType CDNA = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "CDNA";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.queryFeatures("/column/sample").exists();
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final SADLSyntax.InputType AFFY = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "AFFY";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.isContentTypeCompatitible("application/cel");
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final SADLSyntax.InputType GENE_EXPRS = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "GENE_EXPRS";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            try {
                Table chips = dataBean.queryFeatures("/column/chip.*").asTable();
                return chips != null && chips.getColumnCount() > 0;
            }
            catch (MicroarrayException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final SADLSyntax.InputType GENELIST = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "GENELIST";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.queryFeatures("/identifier").exists();
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final SADLSyntax.InputType PHENODATA = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "PHENODATA";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.queryFeatures("/phenodata").exists();
        }

        @Override
        public boolean isMetadata() {
            return true;
        }
    };
    public static final SADLSyntax.InputType BAM = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "BAM";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.isContentTypeCompatitible("application/bam");
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final SADLSyntax.InputType FASTA = new SADLSyntax.InputType(){

        @Override
        public String getName() {
            return "FASTA";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.isContentTypeCompatitible("chemical/x-fasta");
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };

    public static boolean hasRawType(DataBean data) {
        return AFFY.isTypeOf(data) || CDNA.isTypeOf(data);
    }
}

