/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.messaging.message.PayloadMessage;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class JobMessage
extends PayloadMessage {
    private static final Logger logger = Logger.getLogger(JobMessage.class);
    private static final String KEY_JOB_ID = "jobID";
    private static final String KEY_ANALYSIS_ID = "analysisID";
    private String analysisId;
    private String jobId;

    public JobMessage() {
    }

    public JobMessage(String jobId, String analysisId, List<String> parameters) {
        super(parameters);
        this.jobId = jobId;
        this.analysisId = analysisId;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.jobId = from.getString(KEY_JOB_ID);
        this.analysisId = from.getString(KEY_ANALYSIS_ID);
        logger.debug((Object)("Unmarshalled jobID : " + this.jobId));
        logger.debug((Object)("Unmarshalled analysisID : " + this.analysisId));
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        logger.debug((Object)("Marshalling: jobID : " + this.jobId));
        logger.debug((Object)("Marshalling: analysisID : " + this.analysisId));
        mapMessage.setString(KEY_JOB_ID, this.jobId);
        mapMessage.setString(KEY_ANALYSIS_ID, this.analysisId);
    }

    public String getAnalysisId() {
        return this.analysisId;
    }

    public void setAnalysisId(String id) {
        this.analysisId = id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public List<String> getParameters(ParameterSecurityPolicy securityPolicy, ToolDescription description) throws ParameterValidityException {
        if (securityPolicy == null) {
            throw new IllegalArgumentException("security policy cannot be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("analysis description cannot be null");
        }
        int parameterDescriptionCount = 0;
        Iterator<ToolDescription.ParameterDescription> iterator = description.getParameters().iterator();
        while (iterator.hasNext()) {
            ++parameterDescriptionCount;
            iterator.next();
        }
        List<String> parameters = super.getParameters();
        if (parameterDescriptionCount != parameters.size()) {
            throw new IllegalArgumentException("number of parameter descriptions does not match the number of parameter values");
        }
        Iterator<ToolDescription.ParameterDescription> descriptionIterator = description.getParameters().iterator();
        for (String parameter : parameters) {
            ToolDescription.ParameterDescription parameterDescription;
            if (securityPolicy.isValueValid(parameter, parameterDescription = descriptionIterator.next())) continue;
            throw new ParameterValidityException("illegal value for parameter " + parameterDescription.getName() + ": " + parameter);
        }
        return parameters;
    }

    public static class ParameterValidityException
    extends Exception {
        public ParameterValidityException(String msg) {
            super(msg);
        }
    }

    public static interface ParameterSecurityPolicy {
        public boolean isValueValid(String var1, ToolDescription.ParameterDescription var2);
    }
}

