/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiplexingMessagingListener
implements MessagingListener {
    private static final Logger logger = Logger.getLogger(MultiplexingMessagingListener.class);
    private Map<String, MessagingListener> channels = new HashMap<String, MessagingListener>();

    public void addChannel(String channelName, MessagingListener channelListener) {
        this.channels.put(channelName, channelListener);
    }

    public void removeChannel(String channelName) {
        this.channels.remove(channelName);
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        String channelName = msg.getMultiplexChannel();
        logger.debug((Object)("multiplexing to channel " + channelName));
        if (this.channels.get(channelName) != null) {
            this.channels.get(channelName).onChipsterMessage(msg);
        }
    }
}

