/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class AnnotationManager {
    private static final String CONTENTS_FILE = "contents2.txt";
    private static final String ANNOTATIONS_PATH = "annotations";
    private static final Logger logger = Logger.getLogger(AnnotationManager.class);
    public static final String CHR_LOCATION = "[CHR]";
    public static final String START_LOCATION = "[START]";
    public static final String END_LOCATION = "[END]";
    private URL remoteAnnotationsRoot;
    private File localAnnotationsRoot;
    private final String FILE_ID = "CHIPSTER ANNOTATION CONTENTS FILE VERSION 2";
    private final String CHR_UNSPECIFIED = "*";
    private LinkedList<GenomeAnnotation> annotations = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        block15: {
            File localContents;
            block16: {
                this.remoteAnnotationsRoot = this.getRemoteAnnotationsUrl();
                this.localAnnotationsRoot = DirectoryLayout.getInstance().getLocalAnnotationDir();
                boolean remoteContentsOk = false;
                InputStream remoteContentsStream = null;
                URL remoteContents = null;
                if (this.remoteAnnotationsRoot != null) {
                    remoteContents = IOUtils.createURL(this.remoteAnnotationsRoot, CONTENTS_FILE);
                    try {
                        remoteContentsStream = remoteContents.openStream();
                        this.parseFrom(remoteContentsStream);
                        remoteContentsOk = true;
                    }
                    catch (Exception e) {
                        remoteContentsOk = false;
                    }
                    finally {
                        IOUtils.closeIfPossible(remoteContentsStream);
                    }
                }
                localContents = new File(this.localAnnotationsRoot, CONTENTS_FILE);
                if (!remoteContentsOk) break block16;
                logger.info((Object)"using remote annotation contents file");
                FileOutputStream localContentsStream = null;
                try {
                    remoteContentsStream = remoteContents.openStream();
                    localContentsStream = new FileOutputStream(localContents);
                    IOUtils.copy(remoteContentsStream, localContentsStream);
                }
                catch (Exception e) {
                    try {
                        logger.warn((Object)"could not make a local copy of contents file", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeIfPossible(remoteContentsStream);
                        IOUtils.closeIfPossible(localContentsStream);
                        throw throwable;
                    }
                    IOUtils.closeIfPossible(remoteContentsStream);
                    IOUtils.closeIfPossible(localContentsStream);
                    break block15;
                }
                IOUtils.closeIfPossible(remoteContentsStream);
                IOUtils.closeIfPossible(localContentsStream);
                break block15;
            }
            logger.info((Object)"trying to use local annotation contents file");
            BufferedInputStream localContentsStream = null;
            try {
                localContentsStream = new BufferedInputStream(new FileInputStream(localContents));
                this.parseFrom(localContentsStream);
            }
            catch (Exception e) {
                try {
                    throw new Exception("Cannot access genome browser annotations from the server or from the local cache.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeIfPossible(localContentsStream);
                    throw throwable;
                }
            }
            IOUtils.closeIfPossible(localContentsStream);
        }
        this.removeUnnecessaryFiles(this.localAnnotationsRoot);
    }

    private void removeUnnecessaryFiles(File localAnnotationsRoot) {
        String[] allFiles;
        File annotationFolder = localAnnotationsRoot;
        for (String file : allFiles = annotationFolder.list()) {
            if (this.contains(file)) continue;
            File fileToRemove = new File(localAnnotationsRoot, file);
            this.removeFile(fileToRemove);
        }
    }

    private void removeFile(File fileToRemove) {
        if (fileToRemove.getPath().contains(".chipster")) {
            fileToRemove.delete();
        }
    }

    private boolean contains(String file) {
        if (file.equals(CONTENTS_FILE)) {
            return true;
        }
        for (GenomeAnnotation annotation : this.annotations) {
            String path;
            String fileName;
            if (annotation.url == null || !(fileName = (path = annotation.url.getPath()).substring(path.lastIndexOf("/") + 1)).equals(file)) continue;
            return true;
        }
        return false;
    }

    public List<GenomeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<GenomeAnnotation> getAnnotations(Genome genome, AnnotationType annotationType) {
        LinkedList<GenomeAnnotation> filteredAnnotations = new LinkedList<GenomeAnnotation>();
        for (GenomeAnnotation annotation : this.annotations) {
            if (!annotation.getGenome().equals(genome) || annotation.type != annotationType) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    public GenomeAnnotation getAnnotation(Genome genome, AnnotationType annotationType) {
        List<GenomeAnnotation> filteredList = this.getAnnotations(genome, annotationType);
        if (filteredList.size() > 0) {
            return filteredList.get(0);
        }
        return null;
    }

    public List<Genome> getGenomes() {
        LinkedList<Genome> genomes = new LinkedList<Genome>();
        for (GenomeAnnotation annotation : this.annotations) {
            if (genomes.contains(annotation.getGenome())) continue;
            genomes.add(annotation.getGenome());
        }
        return genomes;
    }

    public boolean hasLocalAnnotations(Genome genome) {
        for (AnnotationType c : AnnotationType.values()) {
            GenomeAnnotation annotation;
            if (!c.isClientCacheable() || (annotation = this.getAnnotation(genome, c)) == null || this.checkLocalFile(annotation)) continue;
            return false;
        }
        return true;
    }

    public void downloadAnnotations(final Genome genome) throws IOException {
        Session.getSession().getApplication().runBlockingTask("downloading annotations", new Runnable(){

            @Override
            public void run() {
                for (AnnotationType c : AnnotationType.values()) {
                    GenomeAnnotation annotation;
                    if (!c.isClientCacheable() || (annotation = AnnotationManager.this.getAnnotation(genome, c)) == null || AnnotationManager.this.checkLocalFile(annotation)) continue;
                    try {
                        AnnotationManager.this.downloadAnnotationFile(annotation.url);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    public void openDownloadAnnotationsDialog(final Genome genome) {
        Session.getSession().getApplication().showDialog("Download annotations for " + genome + "?", "Downloading annotations is highly recommended to get optimal performace with genome browser.\n\nYou only need to download annotations once, after that they are stored on your local computer for further use.", "", DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, new ChipsterDialog.PluginButton(){

            @Override
            public void actionPerformed() {
                try {
                    AnnotationManager.this.downloadAnnotations(genome);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getText() {
                return "Download ";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAnnotationFile(URL sourceUrl) throws IOException {
        String fileName = sourceUrl.getPath().substring(sourceUrl.getPath().lastIndexOf(47) + 1);
        File localFile = new File(this.localAnnotationsRoot, fileName);
        InputStream in = null;
        try {
            in = sourceUrl.openStream();
            IOUtils.copy(in, localFile);
        }
        finally {
            IOUtils.closeIfPossible(in);
        }
    }

    private boolean checkLocalFile(GenomeAnnotation annotation) {
        String fileName;
        File localFile;
        if (annotation.url != null && (localFile = new File(this.localAnnotationsRoot, fileName = IOUtils.getFilenameWithoutPath(annotation.url))).exists()) {
            if (localFile.length() == annotation.getContentLength()) {
                return true;
            }
            this.removeFile(localFile);
        }
        return false;
    }

    private void parseFrom(InputStream contentsStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(contentsStream));
        if (!reader.readLine().equals("CHIPSTER ANNOTATION CONTENTS FILE VERSION 2")) {
            throw new IllegalArgumentException("annotation stream does not start with CHIPSTER ANNOTATION CONTENTS FILE VERSION 2");
        }
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) continue;
            String[] splitted = line.split("\t");
            String fileName = splitted[4];
            URL url = "".equals(fileName) ? null : (fileName.startsWith("http://") ? new URL(fileName) : IOUtils.createURL(this.remoteAnnotationsRoot != null ? this.remoteAnnotationsRoot : new URL("file://"), fileName));
            long contentLength = Long.parseLong(splitted[5]);
            Chromosome chr = null;
            if (!splitted[3].equals("*")) {
                chr = new Chromosome(splitted[3]);
            }
            this.addAnnotation(new GenomeAnnotation(splitted[0], splitted[1], splitted[2], chr, url, contentLength));
        }
    }

    public void addAnnotation(GenomeAnnotation annotation) {
        this.annotations.add(annotation);
    }

    private URL getRemoteAnnotationsUrl() throws Exception {
        FileBrokerClient fileBroker = Session.getSession().getServiceAccessor().getFileBrokerClient();
        if (fileBroker.getPublicUrl() != null) {
            return new URL(fileBroker.getPublicUrl() + "/" + ANNOTATIONS_PATH);
        }
        return null;
    }

    public static enum AnnotationType {
        CYTOBANDS("Cytoband"),
        GTF_TABIX("Transcript"),
        GTF_TABIX_INDEX("Transcript index"),
        REPEAT("Repeat"),
        REPEAT_INDEX("Repeat index"),
        REFERENCE("Reference sequence", false),
        REFERENCE_INDEX("Reference sequence index"),
        SNP("ENSEMBL SNP"),
        GENE_CHRS("Gene name"),
        ENSEMBL_BROWSER_URL("Ensembl", false),
        UCSC_BROWSER_URL("UCSC", false);

        private String id;
        private boolean clientCacheable;

        private AnnotationType(String id) {
            this(id, true);
        }

        private AnnotationType(String id, boolean clientCacheable) {
            this.id = id;
            this.clientCacheable = clientCacheable;
        }

        public String getId() {
            return this.id;
        }

        public boolean isClientCacheable() {
            return this.clientCacheable;
        }
    }

    public class Genome {
        public String species;
        public String version;

        public Genome(String species, String version) {
            this.species = species;
            this.version = version;
        }

        public String toString() {
            return this.species + " " + this.version;
        }

        public boolean equals(Object o) {
            if (o instanceof Genome) {
                Genome other = (Genome)o;
                return this.species.equals(other.species) && this.version.equals(other.version);
            }
            return false;
        }

        public int hashCode() {
            return this.species.hashCode();
        }
    }

    public class GenomeAnnotation {
        public String species;
        public String version;
        public AnnotationType type;
        public Chromosome chr;
        private URL url;
        private long contentLength;

        public GenomeAnnotation(String species, String version, String annotationType, Chromosome chr, URL url, long contentLength) {
            this.species = species;
            this.version = version;
            this.chr = chr;
            this.contentLength = contentLength;
            this.url = url;
            for (AnnotationType aType : AnnotationType.values()) {
                if (!aType.id.equals(annotationType)) continue;
                this.type = aType;
            }
        }

        public URL getUrl() {
            if (AnnotationManager.this.checkLocalFile(this)) {
                URL newUrl;
                String fileName = IOUtils.getFilenameWithoutPath(this.url);
                File localFile = new File(AnnotationManager.this.localAnnotationsRoot, fileName);
                try {
                    newUrl = localFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    logger.warn((Object)("generating url for local file " + localFile + "failed"));
                    return this.url;
                }
                return newUrl;
            }
            return this.url;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public Genome getGenome() {
            return new Genome(this.species, this.version);
        }
    }
}

