/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TrackContext;
import fi.csc.microarray.client.visualisation.methods.gbrowser.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.FsfStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageAndSNPTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.QualityCoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class View
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
TooltipAugmentedChartPanel.TooltipRequestProcessor {
    public RegionDouble bpRegion;
    public Region highlight;
    public Collection<TrackGroup> trackGroups = new LinkedList<TrackGroup>();
    protected Rectangle viewArea = new Rectangle(0, 0, 500, 500);
    private QueueManager queueManager;
    private Point2D dragStartPoint;
    private boolean dragStarted;
    public GenomePlot parentPlot;
    protected static final int FPS = 30;
    protected boolean movable;
    protected boolean zoomable;
    protected final float ZOOM_FACTOR = 1.06f;
    protected final float MIN_PIXELS_PER_NUCLEOTIDE = 10.0f;
    private List<RegionListener> listeners = new LinkedList<RegionListener>();
    public int margin = 0;
    protected Float trackHeight;
    private Point2D dragEndPoint;
    private Point2D dragLastStartPoint;
    private Iterator<Track> trackIter;
    private Iterator<Drawable> drawableIter;
    private Track track;
    private float y;
    private int x;
    private BufferedImage drawBuffer;
    private long dragEventTime;
    private boolean isStatic;
    private static final long DRAG_EXPIRATION_TIME_MS = 50L;
    private static boolean showFullHeight = true;
    private static final int Y_MARGIN = 20;
    private Timer mouseAnimationTimer;
    private ViewLimiter viewLimiter;

    public View(GenomePlot parent, boolean movable, boolean zoomable, boolean selectable) {
        this.parentPlot = parent;
        this.movable = movable;
        this.zoomable = zoomable;
    }

    protected abstract void drawDrawable(Graphics2D var1, int var2, int var3, Drawable var4);

    public void addTrack(Track track) {
        this.trackGroups.add(new TrackGroup(track));
    }

    public void addTrackGroup(TrackGroup group) {
        this.trackGroups.add(group);
    }

    public Collection<Track> getTracks() {
        LinkedList<Track> tracks = new LinkedList<Track>();
        for (TrackGroup trackGroup : this.trackGroups) {
            if (!trackGroup.isVisible()) continue;
            tracks.addAll(trackGroup.getTracks());
        }
        return tracks;
    }

    protected void drawView(Graphics2D g, boolean isAnimation) {
        Graphics2D bufG2;
        if (this.bpRegion == null) {
            this.setBpRegion(new RegionDouble(0.0, 2.62144E8, new Chromosome("1")), false);
        }
        showFullHeight = this.parentPlot.isFullHeight();
        this.updateTrackHeights();
        this.viewArea = g.getClipBounds();
        int drawBufferWidth = (int)(this.viewArea.getX() + this.viewArea.getWidth());
        int drawBufferHeight = (int)(this.viewArea.getY() + this.viewArea.getHeight());
        if (this.drawBuffer == null || this.drawBuffer.getWidth() != drawBufferWidth || this.drawBuffer.getHeight() != drawBufferHeight) {
            this.drawBuffer = new BufferedImage(drawBufferWidth, drawBufferHeight, 1);
            this.drawBuffer = new BufferedImage((int)this.viewArea.getWidth(), (int)this.viewArea.getHeight(), 1);
            bufG2 = (Graphics2D)this.drawBuffer.getGraphics();
            bufG2.setPaint(Color.white);
            bufG2.fillRect(0, 0, this.drawBuffer.getWidth(), this.drawBuffer.getHeight());
        }
        bufG2 = (Graphics2D)this.drawBuffer.getGraphics();
        bufG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bufG2.setClip(g.getClip());
        TrackContext trackContext = null;
        this.y = 0.0f;
        this.x = 0;
        if (this.isRulerEnabled()) {
            bufG2.setColor(Color.LIGHT_GRAY);
            bufG2.drawLine(this.drawBuffer.getWidth() / 2, 0, this.drawBuffer.getWidth() / 2, this.drawBuffer.getHeight());
        }
        for (TrackGroup group : this.trackGroups) {
            this.trackIter = group.getTracks().iterator();
            this.drawableIter = null;
            if (!group.isVisible()) continue;
            if (group.isMenuVisible()) {
                group.menu.setPosition((int)(this.viewArea.getX() + this.viewArea.getWidth()), (int)(this.viewArea.getY() + (double)this.y));
            }
            while (this.trackIter.hasNext()) {
                if (this.drawableIter == null || !this.drawableIter.hasNext()) {
                    this.track = this.trackIter.next();
                }
                if (this.track.isVisible()) {
                    boolean expandDrawables = this.track.canExpandDrawables();
                    if (expandDrawables && (this.track instanceof CoverageAndSNPTrack || this.track instanceof QualityCoverageTrack)) {
                        trackContext = this.parentPlot.getReadScale() == GenomePlot.ReadScale.AUTO ? new TrackContext(this.track) : new TrackContext(this.track, this.track.getHeight() - this.parentPlot.getReadScale().numReads);
                    }
                    Collection<Drawable> drawables = this.track.getDrawables();
                    this.drawableIter = drawables.iterator();
                    int maxY = 20;
                    if (showFullHeight && this.track.isStretchable()) {
                        while (this.drawableIter.hasNext()) {
                            Drawable drawable = this.drawableIter.next();
                            if (drawable == null || drawable.getMaxY() <= maxY) continue;
                            maxY = drawable.getMaxY();
                        }
                        this.track.setHeight(maxY + 20);
                    }
                    this.y += (float)this.track.getHeight().intValue();
                    for (Drawable drawable : drawables) {
                        if (drawable == null) continue;
                        if (expandDrawables) {
                            drawable.expand(trackContext);
                        }
                        int maybeReversedY = (int)this.y;
                        if (this.track.isReversed()) {
                            maybeReversedY -= this.track.getHeight().intValue();
                        } else {
                            drawable.upsideDown();
                        }
                        this.drawDrawable(bufG2, this.x, maybeReversedY, drawable);
                    }
                    this.drawableIter = null;
                    continue;
                }
                this.drawableIter = null;
            }
        }
        g.drawImage(this.drawBuffer, (int)this.viewArea.getX(), (int)this.viewArea.getY(), drawBufferWidth, drawBufferHeight, (int)this.viewArea.getX(), (int)this.viewArea.getY(), drawBufferWidth, drawBufferHeight, null);
        bufG2.setPaint(Color.white);
        bufG2.fillRect(0, 0, this.drawBuffer.getWidth(), this.drawBuffer.getHeight());
        this.trackIter = null;
        this.drawableIter = null;
    }

    public boolean isRulerEnabled() {
        return true;
    }

    private void updateTrackHeights() {
        for (Track t : this.getTracks()) {
            if (!t.isStretchable()) continue;
            if (showFullHeight) {
                t.setHeight(Integer.MAX_VALUE);
                continue;
            }
            t.setHeight(Math.round(this.getTrackHeight()));
        }
    }

    public float getTrackHeight() {
        this.trackHeight = Float.valueOf((float)(this.getHeight() - this.getStaticTrackHeightTotal()) / (float)this.getStretchableTrackCount());
        return this.trackHeight.floatValue();
    }

    protected int getStaticTrackHeightTotal() {
        int staticHeightTotal = 0;
        for (Track track : this.getTracks()) {
            if (!track.isVisible() || track.isStretchable()) continue;
            staticHeightTotal += track.getHeight().intValue();
        }
        return staticHeightTotal;
    }

    protected int getTrackHeightTotal() {
        int heightTotal = 0;
        for (Track track : this.getTracks()) {
            if (!track.isVisible() || track.getHeight() == null) continue;
            heightTotal += track.getHeight().intValue();
        }
        if (heightTotal == 0) {
            heightTotal = this.getHeight();
        }
        return heightTotal;
    }

    protected int getStretchableTrackCount() {
        int stretchableCount = 0;
        for (Track track : this.getTracks()) {
            if (!track.isStretchable()) continue;
            ++stretchableCount;
        }
        return stretchableCount;
    }

    public int getWidth() {
        return this.viewArea.width;
    }

    public int getHeight() {
        return this.viewArea.height;
    }

    public void setHeight(int height) {
        this.viewArea.height = height;
    }

    public boolean hasStaticHeight() {
        return this.isStatic;
    }

    public void setStaticHeight(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public QueueManager getQueueManager() {
        if (this.queueManager == null) {
            this.queueManager = new QueueManager();
        }
        return this.queueManager;
    }

    public void fireAreaRequests() {
        FsfStatus status;
        HashMap conciseDatas = new HashMap();
        HashMap<DataSource, Set> preciseDatas = new HashMap<DataSource, Set>();
        for (Track t : this.getTracks()) {
            Map<DataSource, Set<ColumnType>> trackDatas = t.requestedData();
            if (trackDatas == null || !t.isVisible()) continue;
            for (DataSource file : trackDatas.keySet()) {
                Set columns;
                if (file == null) continue;
                HashMap<DataSource, Set> datas = preciseDatas;
                if (t.isConcised()) {
                    datas = conciseDatas;
                }
                columns = (columns = (Set)datas.get(file)) != null ? columns : new HashSet();
                columns.addAll(trackDatas.get(file));
                datas.put(file, columns);
            }
        }
        Region requestRegion = this.getBpRegion();
        for (DataSource file : conciseDatas.keySet()) {
            status = new FsfStatus();
            status.clearQueues = true;
            status.concise = true;
            this.getQueueManager().addAreaRequest(file, new AreaRequest(requestRegion, (Collection)conciseDatas.get(file), status), true);
        }
        for (DataSource file : preciseDatas.keySet()) {
            status = new FsfStatus();
            status.clearQueues = true;
            status.concise = false;
            this.getQueueManager().addAreaRequest(file, new AreaRequest(requestRegion, (Collection)preciseDatas.get(file), status), true);
        }
    }

    public void setBpRegion(RegionDouble region, boolean disableDrawing) {
        RegionDouble limitedRegion = region.clone();
        if (limitedRegion.start.bp < 0.0) {
            limitedRegion.move(-limitedRegion.start.bp.doubleValue());
        }
        if (this.viewLimiter != null && this.viewLimiter.getLimit() != null) {
            BpCoord maxBp = this.viewLimiter.getLimit();
            if (this.viewLimiter.getLimit() != null && this.viewLimiter.getLimit().chr.equals(region.start.chr) && maxBp != null && maxBp.bp != 0L) {
                BpCoord bpCoord = maxBp;
                bpCoord.bp = bpCoord.bp + 100000L;
                if (limitedRegion.getLength() > (double)maxBp.bp.longValue()) {
                    limitedRegion.end.bp = (double)maxBp.bp;
                } else if (limitedRegion.end.bp > (double)maxBp.bp.longValue()) {
                    double delta = limitedRegion.end.bp - (double)maxBp.bp.longValue();
                    limitedRegion.move(-delta);
                }
            }
        }
        this.bpRegion = limitedRegion;
        this.trackHeight = null;
        this.fireAreaRequests();
        if (!disableDrawing) {
            this.dispatchRegionChange();
        }
    }

    public RegionDouble getBpRegionDouble() {
        return this.bpRegion;
    }

    public Region getBpRegion() {
        return new Region((Long)((long)this.bpRegion.start.bp.doubleValue()), this.bpRegion.start.chr, (long)Math.ceil(this.bpRegion.end.bp), this.bpRegion.end.chr);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.parentPlot.chartPanel.requestFocusInWindow();
        this.stopAnimation();
        this.dragStartPoint = this.scale(e.getPoint());
        this.dragStarted = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragStarted && this.dragEndPoint != null && this.dragLastStartPoint != null && Math.abs(this.dragEndPoint.getX() - this.dragLastStartPoint.getX()) > 10.0 && System.currentTimeMillis() - this.dragEventTime < 50L) {
            this.stopAnimation();
            this.mouseAnimationTimer = new Timer(33, new ActionListener(){
                private int i = 2;
                private int ANIMATION_FRAMES = 30;
                private long startTime = System.currentTimeMillis();

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean skipFrame = false;
                    boolean done = false;
                    do {
                        double endX = View.this.dragEndPoint.getX();
                        double startX = View.this.dragLastStartPoint.getX();
                        double newX = endX - (endX - startX) / (double)(this.ANIMATION_FRAMES - this.i);
                        View.this.dragEndPoint = new Point2D.Double(newX, View.this.dragEndPoint.getY());
                        skipFrame = this.i < this.ANIMATION_FRAMES - 1 && System.currentTimeMillis() > this.startTime + (long)(33 * this.i);
                        boolean bl = done = this.i >= this.ANIMATION_FRAMES;
                        if (!done) {
                            View.this.handleDrag(View.this.dragLastStartPoint, View.this.dragEndPoint, skipFrame);
                            ++this.i;
                            continue;
                        }
                        View.this.stopAnimation();
                    } while (skipFrame && !done);
                }
            });
            this.mouseAnimationTimer.setCoalesce(true);
            this.mouseAnimationTimer.setRepeats(true);
            this.mouseAnimationTimer.start();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.movable && (this.dragStartPoint != null && this.viewArea.contains(this.dragStartPoint) || this.viewArea.contains(e.getPoint()))) {
            this.dragStarted = true;
            this.dragEndPoint = this.scale(e.getPoint());
            this.dragEventTime = System.currentTimeMillis();
            this.handleDrag(this.dragStartPoint, this.dragEndPoint, false);
        }
        this.dragLastStartPoint = this.dragStartPoint;
        this.dragStartPoint = this.scale(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected abstract void handleDrag(Point2D var1, Point2D var2, boolean var3);

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.parentPlot.isFullHeight()) {
            this.zoomAnimation((int)this.scale(e.getPoint()).getX(), e.getWheelRotation());
        }
    }

    public void zoomAnimation(final int centerX, final int wheelRotation) {
        this.stopAnimation();
        this.mouseAnimationTimer = new Timer(33, new ActionListener(){
            private int i = 2;
            private long startTime = System.currentTimeMillis();
            private int ANIMATION_FRAMES = 15;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean skipFrame = this.i < this.ANIMATION_FRAMES - 1 && System.currentTimeMillis() > this.startTime + (long)(33 * this.i);
                boolean done = false;
                do {
                    boolean bl = done = this.i >= this.ANIMATION_FRAMES;
                    if (!done) {
                        View.this.zoom(centerX, wheelRotation, skipFrame);
                        ++this.i;
                        continue;
                    }
                    View.this.stopAnimation();
                } while (skipFrame && !done);
            }
        });
        this.mouseAnimationTimer.setRepeats(true);
        this.mouseAnimationTimer.setCoalesce(true);
        this.mouseAnimationTimer.start();
    }

    private void stopAnimation() {
        if (this.mouseAnimationTimer != null) {
            this.mouseAnimationTimer.stop();
            this.mouseAnimationTimer = null;
        }
    }

    protected void zoom(int lockedX, double wheelRotation, boolean disableDrawing) {
        if (this.zoomable) {
            int minBpWidth;
            BpCoordDouble pointerBp = this.trackToBp(lockedX);
            double pointerRelative = this.trackToRelative(lockedX);
            double startBp = this.getBpRegionDouble().start.bp;
            double endBp = this.getBpRegionDouble().end.bp;
            double width = endBp - startBp;
            if ((width *= Math.pow(1.06f, wheelRotation)) < (double)(minBpWidth = (int)((float)this.parentPlot.chartPanel.getPreferredSize().getSize().width / 10.0f))) {
                width = minBpWidth;
            }
            startBp = pointerBp.bp - width * pointerRelative;
            endBp = pointerBp.bp + width * (1.0 - pointerRelative);
            this.setBpRegion(new RegionDouble(startBp, this.getBpRegionDouble().start.chr, endBp, this.getBpRegionDouble().end.chr), disableDrawing);
            if (!disableDrawing) {
                this.parentPlot.redraw();
            }
        }
    }

    public Integer bpToTrack(BpCoord bp) {
        if (this.bpRegion.start.chr.equals(bp.chr)) {
            return (int)Math.round(((double)bp.bp.longValue() - this.getBpRegionDouble().start.bp) * (double)this.bpWidth().floatValue() + (double)this.getX());
        }
        return null;
    }

    public Float bpToTrackFloat(BpCoord bp) {
        if (this.bpRegion.start.chr.equals(bp.chr)) {
            return Float.valueOf((float)(((double)bp.bp.longValue() - this.getBpRegionDouble().start.bp) * (double)this.bpWidth().floatValue()) + (float)this.getX());
        }
        return null;
    }

    public Float bpWidth() {
        return Float.valueOf((float)this.getWidth() / (float)this.getBpRegionDouble().getLength());
    }

    public BpCoordDouble trackToBp(double d) {
        return new BpCoordDouble(this.trackToRelative(d) * (this.getBpRegionDouble().end.bp - this.getBpRegionDouble().start.bp) + this.getBpRegionDouble().start.bp, this.bpRegion.start.chr);
    }

    public double trackToRelative(double track) {
        return (track - (double)this.getX()) / (double)this.getWidth();
    }

    public int getX() {
        return this.viewArea.x;
    }

    public int getY() {
        return this.viewArea.y;
    }

    public void redraw() {
        if (this.mouseAnimationTimer == null || !this.mouseAnimationTimer.isRunning()) {
            this.parentPlot.redraw();
        }
    }

    public List<Long> getRulerInfo() {
        for (Track t : this.getTracks()) {
            if (!(t instanceof RulerTrack)) continue;
            RulerTrack ruler = (RulerTrack)t;
            return ruler.getRulerInfo();
        }
        return null;
    }

    public void addRegionListener(RegionListener listener) {
        this.listeners.add(listener);
    }

    public void dispatchRegionChange() {
        for (RegionListener listener : this.listeners) {
            listener.regionChanged(this.getBpRegion());
        }
    }

    private Point2D scale(Point2D p) {
        return new Point((int)(p.getX() / this.parentPlot.chartPanel.getScaleX()), (int)(p.getY() / this.parentPlot.chartPanel.getScaleY()));
    }

    @Override
    public String tooltipRequest(MouseEvent mouseEvent) {
        Point locationOnPanel = (Point)mouseEvent.getLocationOnScreen().clone();
        SwingUtilities.convertPointFromScreen(locationOnPanel, (Component)((Object)this.parentPlot.chartPanel));
        return this.tooltipRequest(locationOnPanel);
    }

    public String tooltipRequest(Point2D locationOnPanel) {
        return null;
    }

    public void clean() {
        if (this.queueManager != null) {
            this.queueManager.poisonAll();
        }
        this.trackGroups.clear();
        this.queueManager = null;
    }

    public void setViewLimiter(ViewLimiter viewLimiter) {
        this.viewLimiter = viewLimiter;
    }
}

