/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.chipster.tools.gbrowser.SamBamUtils;
import fi.csc.chipster.tools.gbrowser.regions.RegionOperations;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.LinkUtil;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.selection.PointSelectionEvent;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.CytobandDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowserLegend;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.IndexedFastaDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.SAMDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TabixSummaryDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TrackFactory;
import fi.csc.microarray.client.visualisation.methods.gbrowser.UnsortedDataException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BedTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkTreeHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GeneSearchHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GtfTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TabixSummaryHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.BEDParserWithCoordinateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ElandParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.HeaderTsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.VcfParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.gbrowser.index.GeneIndexActions;
import fi.csc.microarray.util.BrowserLauncher;
import fi.csc.microarray.util.IOUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXHyperlink;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class GenomeBrowser
extends Visualisation
implements ActionListener,
RegionListener,
ComponentListener,
PropertyChangeListener {
    private static final long DEFAULT_VIEWSIZE = 100000L;
    private static final long DEFAULT_LOCATION = 1000000L;
    static final String WAITPANEL = "waitpanel";
    static final String PLOTPANEL = "plotpanel";
    private static final String COVERAGE_NONE = "none";
    private static final String COVERAGE_TOTAL = "total";
    private static final String COVERAGE_STRAND = "strand-specific";
    private final ClientApplication application = Session.getSession().getApplication();
    private List<Interpretation> interpretations;
    private List<Track> tracks = new LinkedList<Track>();
    private GenomePlot plot;
    private JPanel paramPanel;
    private JPanel settingsPanel = new JPanel();
    private JPanel genomePanel;
    private JPanel locationPanel;
    private JPanel datasetsPanel;
    private JPanel datasetSwitchesPanel;
    private JPanel optionsPanel;
    private JPanel linksPanel;
    private JPanel plotPanel = new JPanel(new CardLayout());
    private JButton goButton = new JButton("Go");
    private JLabel locationLabel = new JLabel("Location (gene or position)");
    private JTextField locationField = new JTextField();
    private JLabel viewsizeLabel = new JLabel("View size");
    private JTextField viewsizeField = new JTextField();
    private JLabel chrLabel = new JLabel("Chromosome");
    private JComboBox chrBox = new JComboBox();
    private JComboBox genomeBox = new JComboBox();
    private AnnotationManager annotationManager;
    private JLabel coverageScaleLabel = new JLabel("Coverage scale");
    private JComboBox coverageScaleBox = new JComboBox();
    private JLabel coverageTypeLabel = new JLabel("Coverage type");
    private JComboBox coverageTypeBox = new JComboBox();
    private GeneIndexActions gia;
    private boolean initialised;
    private Map<JCheckBox, String> trackSwitches = new LinkedHashMap<JCheckBox, String>();
    private Set<JCheckBox> datasetSwitches = new HashSet<JCheckBox>();
    private Long lastLocation;
    private Long lastViewsize;
    private JScrollPane verticalScroller;
    private JCheckBox showFullHeightBox;
    private ViewLimiter viewLimiter;
    protected boolean geneSearchDone;
    private JXHyperlink ensemblLink;
    private JXHyperlink ucscLink;

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
        this.annotationManager = new AnnotationManager();
        this.annotationManager.initialize();
        this.trackSwitches.put(new JCheckBox("Reads", true), "Reads");
        this.trackSwitches.put(new JCheckBox("Highlight SNPs", true), "highlightSNP");
        this.trackSwitches.put(new JCheckBox("Density graph", false), "GelTrack");
        this.trackSwitches.put(new JCheckBox("Low complexity regions", false), "RepeatMaskerTrack");
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout(new GridBagLayout());
            JPanel settings = this.createSettingsPanel();
            JScrollPane settingsScrollPane = new JScrollPane(settings);
            settingsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            settingsScrollPane.setHorizontalScrollBarPolicy(31);
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settingsScrollPane);
            tabPane.addTab("Legend", new GBrowserLegend());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.anchor = 18;
            c.fill = 1;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.insets.set(5, 0, 0, 0);
            this.paramPanel.add((Component)tabPane, c);
        }
        return this.paramPanel;
    }

    private void createAvailableTracks() {
        this.tracks.add(new Track(AnnotationManager.AnnotationType.GTF_TABIX.getId(), new Interpretation(TrackType.GENES, null)));
        this.tracks.add(new Track(AnnotationManager.AnnotationType.CYTOBANDS.getId(), new Interpretation(TrackType.CYTOBANDS, null)));
        for (int i = 0; i < this.interpretations.size(); ++i) {
            Interpretation interpretation = this.interpretations.get(i);
            DataBean data = interpretation.primaryData;
            this.tracks.add(new Track(data.getName(), interpretation));
        }
        this.updateDatasetSwitches();
    }

    private JPanel getDatasetsPanel() {
        if (this.datasetsPanel == null) {
            this.datasetsPanel = new JPanel(new GridBagLayout());
            this.datasetsPanel.setBorder(VisualConstants.createSettingsPanelSubPanelBorder("Datasets"));
            GridBagConstraints dc = new GridBagConstraints();
            dc.gridy = 0;
            dc.gridx = 0;
            dc.anchor = 18;
            dc.fill = 1;
            dc.weighty = 1.0;
            dc.weightx = 1.0;
            this.datasetSwitchesPanel = new JPanel();
            this.datasetSwitchesPanel.setLayout(new BoxLayout(this.datasetSwitchesPanel, 1));
            this.datasetsPanel.add((Component)this.datasetSwitchesPanel, dc);
        }
        return this.datasetsPanel;
    }

    private void updateDatasetSwitches() {
        this.datasetSwitches.clear();
        this.datasetSwitchesPanel.removeAll();
        for (Track track : this.tracks) {
            JCheckBox box = new JCheckBox(track.name, true);
            box.setToolTipText(track.name);
            box.setEnabled(false);
            track.checkBox = box;
            if (!track.interpretation.type.isToggleable) continue;
            this.datasetSwitchesPanel.add(box);
            this.datasetSwitches.add(box);
            box.addActionListener(this);
        }
    }

    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel(new GridBagLayout());
            this.optionsPanel.setBorder(VisualConstants.createSettingsPanelSubPanelBorder("Options"));
            GridBagConstraints oc = new GridBagConstraints();
            oc.gridy = 0;
            oc.gridx = 0;
            oc.anchor = 19;
            oc.fill = 1;
            oc.weighty = 1.0;
            oc.weightx = 1.0;
            JPanel menu = new JPanel(new GridBagLayout());
            menu.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane menuScrollPane = new JScrollPane(menu);
            menuScrollPane.setHorizontalScrollBarPolicy(31);
            menuScrollPane.setBorder(BorderFactory.createEmptyBorder());
            GridBagConstraints c = new GridBagConstraints();
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.anchor = 19;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            this.setTrackSwitchesEnabled(false);
            for (JCheckBox trackSwitch : this.trackSwitches.keySet()) {
                trackSwitch.addActionListener(this);
                menu.add((Component)trackSwitch, c);
                ++c.gridy;
            }
            this.coverageTypeLabel.setEnabled(false);
            c.insets.set(10, 0, 0, 0);
            menu.add((Component)this.coverageTypeLabel, c);
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.coverageTypeBox = new JComboBox<String>(new String[]{COVERAGE_NONE, COVERAGE_TOTAL, COVERAGE_STRAND});
            this.coverageTypeBox.setSelectedItem(COVERAGE_TOTAL);
            this.coverageTypeBox.setEnabled(false);
            this.coverageTypeBox.addActionListener(this);
            menu.add((Component)this.coverageTypeBox, c);
            ++c.gridy;
            this.coverageScaleLabel.setEnabled(false);
            c.insets.set(10, 0, 0, 0);
            menu.add((Component)this.coverageScaleLabel, c);
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.coverageScaleBox = new JComboBox<GenomePlot.ReadScale>(GenomePlot.ReadScale.values());
            this.coverageScaleBox.setEnabled(false);
            this.coverageScaleBox.addActionListener(this);
            menu.add((Component)this.coverageScaleBox, c);
            ++c.gridy;
            this.showFullHeightBox = new JCheckBox("Show all reads", false);
            this.showFullHeightBox.setEnabled(false);
            this.showFullHeightBox.addActionListener(this);
            menu.add((Component)this.showFullHeightBox, c);
            this.optionsPanel.add((Component)menu, oc);
        }
        return this.optionsPanel;
    }

    private JPanel getExternalLinkPanel() {
        if (this.linksPanel == null) {
            this.linksPanel = new JPanel(new GridBagLayout());
            this.linksPanel.setBorder(VisualConstants.createSettingsPanelSubPanelBorder("External links"));
            this.ensemblLink = LinkUtil.createLink("Ensembl", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GenomeBrowser.this.openExternalBrowser(AnnotationManager.AnnotationType.ENSEMBL_BROWSER_URL);
                }
            });
            this.ucscLink = LinkUtil.createLink("UCSC", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GenomeBrowser.this.openExternalBrowser(AnnotationManager.AnnotationType.UCSC_BROWSER_URL);
                }
            });
            this.ensemblLink.setEnabled(false);
            this.ucscLink.setEnabled(false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 0.0;
            c.weighty = 0.0;
            LinkedList<JXHyperlink> importLinks = new LinkedList<JXHyperlink>();
            importLinks.add(this.ensemblLink);
            importLinks.add(this.ucscLink);
            int MAX_ROW_CHARS = 33;
            LinkUtil.addLinks("View this region in *** or *** genome browser.", importLinks, null, c, this.linksPanel, 33, null);
            JPanel bottomPanel = new JPanel();
            JPanel rightPanel = new JPanel();
            c.weightx = 0.0;
            c.weighty = 1.0;
            c.fill = 3;
            c.gridx = 1;
            ++c.gridy;
            this.linksPanel.add((Component)bottomPanel, c);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 1;
            this.linksPanel.add((Component)rightPanel, c);
        }
        return this.linksPanel;
    }

    private void setExternalLinksEnabled() {
        boolean hasLocation = this.plot != null && this.plot.getDataView() != null && this.plot.getDataView().getBpRegion() != null;
        this.ensemblLink.setEnabled(hasLocation && this.getExternalLinkUrl(AnnotationManager.AnnotationType.ENSEMBL_BROWSER_URL).length() > 0);
        this.ucscLink.setEnabled(hasLocation && this.getExternalLinkUrl(AnnotationManager.AnnotationType.UCSC_BROWSER_URL).length() > 0);
    }

    private String getExternalLinkUrl(AnnotationManager.AnnotationType browser) {
        AnnotationManager.Genome genome = (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
        URL url = this.annotationManager.getAnnotation(genome, browser).getUrl();
        if (url != null) {
            return url.toString();
        }
        return "";
    }

    public void openExternalBrowser(AnnotationManager.AnnotationType browser) {
        String url = this.getExternalLinkUrl(browser);
        Region region = this.plot.getDataView().getBpRegion();
        url = url.replace("[CHR]", region.start.chr.toNormalisedString());
        url = url.replace("[START]", region.start.bp.toString());
        url = url.replace("[END]", region.end.bp.toString());
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            this.application.reportException(e);
        }
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets.set(0, 5, 15, 5);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.settingsPanel.add((Component)this.getGenomePanel(), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.getLocationPanel(), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.getOptionsPanel(), c);
        ++c.gridy;
        c.insets.set(0, 5, 5, 5);
        this.settingsPanel.add((Component)this.getDatasetsPanel(), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.settingsPanel.add((Component)this.getExternalLinkPanel(), c);
        return this.settingsPanel;
    }

    private JPanel getGenomePanel() {
        if (this.genomePanel == null) {
            this.genomePanel = new JPanel(new GridBagLayout());
            this.genomePanel.setBorder(VisualConstants.createSettingsPanelSubPanelBorder("Genome"));
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.insets.set(5, 0, 5, 0);
            c.anchor = 18;
            c.fill = 2;
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridx = 0;
            List<AnnotationManager.Genome> genomes = this.annotationManager.getGenomes();
            for (AnnotationManager.Genome genome : genomes) {
                this.genomeBox.addItem(genome);
            }
            this.genomeBox.setSelectedItem(null);
            this.genomeBox.addActionListener(this);
            this.genomePanel.add((Component)this.genomeBox, c);
        }
        return this.genomePanel;
    }

    private JPanel getLocationPanel() {
        if (this.locationPanel == null) {
            this.locationPanel = new JPanel(new GridBagLayout());
            this.locationPanel.setBorder(VisualConstants.createSettingsPanelSubPanelBorder("Location"));
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.anchor = 18;
            c.fill = 2;
            c.weighty = 0.0;
            c.weightx = 1.0;
            this.chrLabel.setEnabled(false);
            this.locationPanel.add((Component)this.chrLabel, c);
            ++c.gridy;
            this.chrBox.setEnabled(false);
            c.insets.set(0, 0, 10, 0);
            this.locationPanel.add((Component)this.chrBox, c);
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.locationLabel.setEnabled(false);
            this.locationPanel.add((Component)this.locationLabel, c);
            this.locationField.setEnabled(false);
            this.locationField.addActionListener(this);
            ++c.gridy;
            c.insets.set(0, 0, 10, 0);
            this.locationPanel.add((Component)this.locationField, c);
            c.gridx = 0;
            c.gridwidth = 5;
            ++c.gridy;
            c.insets.set(0, 0, 0, 0);
            this.viewsizeLabel.setEnabled(false);
            this.locationPanel.add((Component)this.viewsizeLabel, c);
            c.gridwidth = 4;
            ++c.gridy;
            c.insets.set(0, 0, 10, 0);
            this.viewsizeField.setEnabled(false);
            this.viewsizeField.setEditable(false);
            this.locationPanel.add((Component)this.viewsizeField, c);
            ++c.gridy;
            c.fill = 2;
            c.anchor = 10;
            this.goButton.setEnabled(false);
            this.goButton.addActionListener(this);
            this.locationPanel.add((Component)this.goButton, c);
        }
        return this.locationPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillChromosomeBox() throws IOException {
        DataBean data;
        TreeSet<String> chromosomeNames = new TreeSet<String>();
        for (Interpretation interpretation : this.interpretations) {
            if (interpretation.type != TrackType.READS) continue;
            data = interpretation.primaryData;
            InputStream in = null;
            try {
                in = data.getContentByteStream();
                chromosomeNames.addAll(SamBamUtils.readChromosomeNames(in));
            }
            finally {
                IOUtils.closeIfPossible(in);
            }
        }
        if (chromosomeNames.isEmpty()) {
            for (Interpretation interpretation : this.interpretations) {
                if (interpretation.type != TrackType.REGIONS) continue;
                data = interpretation.primaryData;
                File file = Session.getSession().getDataManager().getLocalFile(data);
                List<RegionContent> rows = null;
                try {
                    rows = new RegionOperations().loadFile(file);
                    for (RegionContent row : rows) {
                        chromosomeNames.add(row.region.start.chr.toNormalisedString());
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        LinkedList<Chromosome> chromosomes = new LinkedList<Chromosome>();
        for (String chromosomeName : chromosomeNames) {
            chromosomes.add(new Chromosome(chromosomeName));
        }
        Collections.sort(chromosomes);
        for (Chromosome chromosome : chromosomes) {
            this.chrBox.addItem(chromosome);
        }
    }

    protected JComponent getColorLabel() {
        return new JLabel("Color: ");
    }

    public void updateVisibilityForTracks() {
        for (Track track : this.tracks) {
            if (track.trackGroup == null) continue;
            for (JCheckBox trackSwitch : this.trackSwitches.keySet()) {
                track.trackGroup.showOrHide(this.trackSwitches.get(trackSwitch), trackSwitch.isSelected());
            }
            if (!(track.trackGroup instanceof ReadTrackGroup)) continue;
            if (this.coverageTypeBox.getSelectedItem().equals(COVERAGE_NONE)) {
                track.trackGroup.showOrHide("ProfileSNPTrack", false);
                track.trackGroup.showOrHide("ProfileTrack", false);
                track.trackGroup.showOrHide("ReadOverview", false);
                continue;
            }
            if (this.coverageTypeBox.getSelectedItem().equals(COVERAGE_TOTAL)) {
                track.trackGroup.showOrHide("ProfileSNPTrack", true);
                track.trackGroup.showOrHide("ProfileTrack", false);
                track.trackGroup.showOrHide("ReadOverview", true);
                continue;
            }
            if (!this.coverageTypeBox.getSelectedItem().equals(COVERAGE_STRAND)) continue;
            track.trackGroup.showOrHide("ProfileSNPTrack", false);
            track.trackGroup.showOrHide("ProfileTrack", true);
            track.trackGroup.showOrHide("ReadOverview", true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.goButton || source == this.locationField) {
            this.genomeBox.setEnabled(false);
            if (!this.initialised) {
                this.application.runBlockingTask("initialising genome browser", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GenomeBrowser.this.initialiseUserDatas();
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GenomeBrowser.this.showVisualisation();
                                    }
                                    catch (Exception e) {
                                        GenomeBrowser.this.application.reportException(e);
                                    }
                                }
                            });
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GenomeBrowser.this.updateLocation();
                                        GenomeBrowser.this.setExternalLinksEnabled();
                                        GenomeBrowser.this.initialised = true;
                                    }
                                    catch (Exception e) {
                                        GenomeBrowser.this.application.reportException(e);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                this.updateLocation();
                this.setExternalLinksEnabled();
            }
        } else if (this.datasetSwitches.contains(source) && this.initialised) {
            this.showFullHeightBox.setSelected(false);
            this.setFullHeight(false);
            this.updateTracks();
        } else if (source == this.coverageScaleBox && this.initialised) {
            this.updateCoverageScale();
        } else if ((this.trackSwitches.keySet().contains(source) || source == this.coverageTypeBox) && this.initialised) {
            this.updateVisibilityForTracks();
        } else if (source == this.genomeBox) {
            AnnotationManager.Genome genome = (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
            if (!this.annotationManager.hasLocalAnnotations(genome)) {
                this.annotationManager.openDownloadAnnotationsDialog(genome);
            }
            this.goButton.setEnabled(true);
            this.chrLabel.setEnabled(true);
            this.chrBox.setEnabled(true);
            this.locationLabel.setEnabled(true);
            this.locationField.setEnabled(true);
            this.viewsizeLabel.setEnabled(true);
            this.viewsizeField.setEnabled(true);
            this.showFullHeightBox.setEnabled(true);
            for (Track track : this.tracks) {
                track.checkBox.setEnabled(true);
            }
            this.coverageTypeLabel.setEnabled(true);
            this.coverageTypeBox.setEnabled(true);
            this.coverageScaleLabel.setEnabled(true);
            this.coverageScaleBox.setEnabled(true);
            this.setTrackSwitchesEnabled(true);
        } else if (source == this.showFullHeightBox && this.initialised) {
            this.setFullHeight(this.showFullHeightBox.isSelected());
        }
    }

    private void setFullHeight(boolean fullHeight) {
        if (fullHeight) {
            this.verticalScroller.setVerticalScrollBarPolicy(22);
        } else {
            this.verticalScroller.setVerticalScrollBarPolicy(21);
        }
        this.plot.setFullHeight(fullHeight);
    }

    private void setTrackSwitchesEnabled(boolean enabled) {
        for (JCheckBox trackSwitch : this.trackSwitches.keySet()) {
            trackSwitch.setEnabled(enabled);
        }
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        return this.getVisualisation(Arrays.asList(data));
    }

    @Override
    public JComponent getVisualisation(List<DataBean> datas) throws Exception {
        this.interpretations = this.interpretUserDatas(datas);
        this.fillChromosomeBox();
        this.tracks.clear();
        this.createAvailableTracks();
        JPanel waitPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        waitPanel.add((Component)new JLabel("<html><p style=\"font-size: larger\">Please select genome and click " + this.goButton.getText() + "</p></html>"), c);
        this.plotPanel.add((Component)waitPanel, WAITPANEL);
        return this.plotPanel;
    }

    private void updateCoverageScale() {
        this.plot.setReadScale((GenomePlot.ReadScale)((Object)this.coverageScaleBox.getSelectedItem()));
    }

    private AnnotationManager.Genome getGenome() {
        return (AnnotationManager.Genome)this.genomeBox.getSelectedItem();
    }

    private void updateTracks() {
        this.plot.getDataView().clean();
        AnnotationManager.Genome genome = this.getGenome();
        for (Track track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            switch (track.interpretation.type) {
                case CYTOBANDS: {
                    URL cytobandUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.CYTOBANDS).getUrl();
                    try {
                        CytobandDataSource cytobandDataSource = new CytobandDataSource(cytobandUrl);
                        TrackFactory.addCytobandTracks(this.plot, cytobandDataSource);
                        this.viewLimiter = new ViewLimiter(this.plot.getOverviewView().getQueueManager(), cytobandDataSource, this.plot.getOverviewView());
                        this.plot.getDataView().setViewLimiter(this.viewLimiter);
                        this.plot.getOverviewView().setViewLimiter(this.viewLimiter);
                    }
                    catch (FileNotFoundException e) {
                        this.application.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.application.reportException(e);
                    }
                    break;
                }
                case GENES: {
                    this.plot.getDataView().addTrack(new SeparatorTrack3D(this.plot.getDataView(), 0L, Long.MAX_VALUE, true));
                    URL gtfUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GTF_TABIX).getUrl();
                    URL gtfIndexUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX).getUrl();
                    URL repeatUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.REPEAT).getUrl();
                    URL repeatIndexUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.REPEAT_INDEX).getUrl();
                    try {
                        TabixDataSource gtfDataSource = new TabixDataSource(gtfUrl, gtfIndexUrl, GtfTabixHandlerThread.class);
                        TabixDataSource repeatDataSource = new TabixDataSource(repeatUrl, repeatIndexUrl, BedTabixHandlerThread.class);
                        TrackGroup geneGroup = TrackFactory.addGeneTracks(this.plot, gtfDataSource, repeatDataSource);
                        track.setTrackGroup(geneGroup);
                    }
                    catch (URISyntaxException e) {
                        this.application.reportException(e);
                    }
                    catch (IOException e) {
                        this.application.reportException(e);
                    }
                    break;
                }
                case REFERENCE: {
                    break;
                }
            }
        }
        for (Track track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            try {
                DataSource treatmentData;
                File file;
                File file2 = file = track.interpretation.primaryData == null ? null : Session.getSession().getDataManager().getLocalFile(track.interpretation.primaryData);
                if (track.interpretation.type != TrackType.READS) continue;
                URL fastaUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.REFERENCE).getUrl();
                URL fastaIndexUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.REFERENCE_INDEX).getUrl();
                IndexedFastaDataSource refSeqDataSource = new IndexedFastaDataSource(fastaUrl, fastaIndexUrl);
                if (track.interpretation.summaryDatas.size() == 0) {
                    TrackFactory.addThickSeparatorTrack(this.plot);
                    treatmentData = this.createReadDataSource(track.interpretation.primaryData, track.interpretation.indexData, this.tracks);
                    TrackGroup readGroup = TrackFactory.addReadTracks(this.plot, treatmentData, refSeqDataSource, track.interpretation.primaryData.getName());
                    track.setTrackGroup(readGroup);
                    continue;
                }
                TrackFactory.addThickSeparatorTrack(this.plot);
                treatmentData = this.createReadDataSource(track.interpretation.primaryData, track.interpretation.indexData, this.tracks);
                TrackGroup readGroupWithSummary = TrackFactory.addReadSummaryTracks(this.plot, treatmentData, refSeqDataSource, track.interpretation.primaryData.getName(), new TabixDataSource(file.toURI().toURL(), null, (Class<? extends AreaRequestHandler>)TabixSummaryHandlerThread.class));
                track.setTrackGroup(readGroupWithSummary);
            }
            catch (IOException e) {
                this.application.reportException(e);
            }
            catch (MicroarrayException e) {
                this.application.reportException(e);
            }
            catch (URISyntaxException e) {
                this.application.reportException(e);
            }
        }
        for (Track track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            URL fileUrl = null;
            if (track.interpretation.primaryData != null) {
                try {
                    File file = Session.getSession().getDataManager().getLocalFile(track.interpretation.primaryData);
                    fileUrl = file.toURI().toURL();
                }
                catch (IOException e) {
                    this.application.reportException(e);
                }
            }
            switch (track.interpretation.type) {
                case REGIONS: {
                    ChunkDataSource regionData;
                    TrackFactory.addThickSeparatorTrack(this.plot);
                    TrackFactory.addTitleTrack(this.plot, track.interpretation.primaryData.getName());
                    try {
                        regionData = new ChunkDataSource(fileUrl, new BEDParserWithCoordinateConversion(), ChunkTreeHandlerThread.class);
                        regionData.checkSorting();
                        TrackFactory.addPeakTrack(this.plot, regionData);
                    }
                    catch (FileNotFoundException e) {
                        this.application.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.application.reportException(e);
                    }
                    catch (IOException e) {
                        this.application.reportException(e);
                    }
                    catch (MicroarrayException e) {
                        this.application.reportException(e);
                    }
                    catch (UnsortedDataException e) {
                        this.application.showDialog("Unsorted data", e.getMessage(), null, DialogInfo.Severity.WARNING, true);
                    }
                    break;
                }
                case REGIONS_WITH_HEADER: {
                    ChunkDataSource regionData;
                    TrackFactory.addThickSeparatorTrack(this.plot);
                    TrackFactory.addTitleTrack(this.plot, track.interpretation.primaryData.getName());
                    try {
                        regionData = new ChunkDataSource(fileUrl, new HeaderTsvParser(), ChunkTreeHandlerThread.class);
                        TrackFactory.addPeakTrack(this.plot, regionData);
                    }
                    catch (FileNotFoundException e) {
                        this.application.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.application.reportException(e);
                    }
                    break;
                }
                case VCF: {
                    ChunkDataSource regionData;
                    TrackFactory.addThickSeparatorTrack(this.plot);
                    TrackFactory.addTitleTrack(this.plot, track.interpretation.primaryData.getName());
                    try {
                        regionData = new ChunkDataSource(fileUrl, new VcfParser(), ChunkTreeHandlerThread.class);
                        TrackFactory.addPeakTrack(this.plot, regionData);
                        break;
                    }
                    catch (FileNotFoundException e) {
                        this.application.reportException(e);
                        break;
                    }
                    catch (URISyntaxException e) {
                        this.application.reportException(e);
                    }
                }
            }
        }
        this.plot.getDataView().addTrack(new SeparatorTrack3D(this.plot.getDataView(), 0L, Long.MAX_VALUE, false));
        this.updateVisibilityForTracks();
    }

    private void showVisualisation() {
        if (this.plot != null) {
            this.plot.clean();
        }
        TooltipAugmentedChartPanel chartPanel = new TooltipAugmentedChartPanel();
        this.plot = new GenomePlot(chartPanel, true);
        chartPanel.setGenomePlot(this.plot);
        this.plot.getDataView().setBpRegion(new RegionDouble(950000.0, 1050000.0, (Chromosome)this.chrBox.getSelectedItem()), true);
        this.updateCoverageScale();
        this.updateTracks();
        this.plot.addDataRegionListener(this);
        chartPanel.setChart(new JFreeChart((Plot)this.plot));
        chartPanel.setCursor(new Cursor(12));
        for (View view : this.plot.getViews()) {
            chartPanel.addMouseListener(view);
            chartPanel.addMouseMotionListener(view);
            chartPanel.addMouseWheelListener(view);
        }
        this.application.removeClientEventListener(this);
        this.application.addClientEventListener(this);
        if (this.plotPanel.getComponentCount() == 2) {
            this.plotPanel.remove(1);
        }
        this.verticalScroller = new JScrollPane((Component)((Object)chartPanel));
        this.setFullHeight(this.showFullHeightBox.isSelected());
        this.plotPanel.add((Component)this.verticalScroller, PLOTPANEL);
        this.plotPanel.addComponentListener(this);
        CardLayout cl = (CardLayout)this.plotPanel.getLayout();
        cl.show(this.plotPanel, PLOTPANEL);
    }

    private GeneIndexActions getGeneIndexActions() {
        if (this.gia == null) {
            AnnotationManager.Genome genome = this.getGenome();
            try {
                URL gtfUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GTF_TABIX).getUrl();
                URL gtfIndexUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX).getUrl();
                URL geneUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GENE_CHRS).getUrl();
                TabixDataSource gtfDataSource = new TabixDataSource(gtfUrl, gtfIndexUrl, GtfTabixHandlerThread.class);
                LineDataSource geneDataSource = new LineDataSource(geneUrl, GeneSearchHandler.class);
                this.gia = new GeneIndexActions(this.plot.getDataView().getQueueManager(), gtfDataSource, geneDataSource);
            }
            catch (Exception e) {
                this.application.reportException(e);
            }
        }
        return this.gia;
    }

    private void initialiseUserDatas() throws IOException {
        for (Interpretation interpretation : this.interpretations) {
            this.initialiseUserData(interpretation.primaryData);
            this.initialiseUserData(interpretation.indexData);
            for (DataBean summaryData : interpretation.summaryDatas) {
                this.initialiseUserData(summaryData);
            }
        }
    }

    private void initialiseUserData(DataBean data) throws IOException {
        if (data != null) {
            Session.getSession().getDataManager().getLocalFile(data);
        }
    }

    public DataSource createReadDataSource(DataBean data, DataBean indexData, List<Track> tracks) throws MicroarrayException, IOException, URISyntaxException {
        DataSource dataSource = null;
        File file = data == null ? null : Session.getSession().getDataManager().getLocalFile(data);
        URL fileUrl = file.toURI().toURL();
        if (data.getName().contains(".bam-summary")) {
            dataSource = new TabixSummaryDataSource(fileUrl);
        } else if (data.getName().contains(".bam") || data.getName().contains(".sam")) {
            File indexFile = Session.getSession().getDataManager().getLocalFile(indexData);
            URL indexFileUrl = indexFile.toURI().toURL();
            dataSource = new SAMDataSource(fileUrl, indexFileUrl);
        } else {
            dataSource = new ChunkDataSource(fileUrl, new ElandParser(), ChunkTreeHandlerThread.class);
        }
        return dataSource;
    }

    private boolean isIndexData(DataBean bean) {
        return bean.getName().endsWith(".bai");
    }

    @Override
    public boolean canVisualise(DataBean data) throws MicroarrayException {
        return this.canVisualise(Arrays.asList(data));
    }

    @Override
    public boolean canVisualise(List<DataBean> datas) throws MicroarrayException {
        return this.interpretUserDatas(datas) != null;
    }

    @Override
    public void regionChanged(Region bpRegion) {
        this.setCoordinateFields(bpRegion.getMid(), bpRegion.getLength());
        this.lastLocation = bpRegion.getMid();
        this.lastViewsize = bpRegion.getLength();
    }

    private List<Interpretation> interpretUserDatas(List<DataBean> datas) {
        LinkedList<Interpretation> interpretations = new LinkedList<Interpretation>();
        for (DataBean data : datas) {
            if (data.isContentTypeCompatitible("text/plain")) {
                interpretations.add(new Interpretation(TrackType.READS, data));
                continue;
            }
            if (data.isContentTypeCompatitible("text/bed")) {
                interpretations.add(new Interpretation(TrackType.REGIONS, data));
                continue;
            }
            if (data.isContentTypeCompatitible("text/tab")) {
                interpretations.add(new Interpretation(TrackType.REGIONS_WITH_HEADER, data));
                continue;
            }
            if (data.isContentTypeCompatitible("application/bam")) {
                interpretations.add(new Interpretation(TrackType.READS, data));
                continue;
            }
            if (!data.isContentTypeCompatitible("text/vcf")) continue;
            interpretations.add(new Interpretation(TrackType.VCF, data));
        }
        for (DataBean data : datas) {
            Interpretation primaryInterpretation = null;
            for (Interpretation interpretation : interpretations) {
                if (!data.getName().startsWith(interpretation.primaryData.getName())) continue;
                primaryInterpretation = interpretation;
                break;
            }
            if (primaryInterpretation == null) {
                return null;
            }
            if (data.isContentTypeCompatitible("application/octet-stream") && data.getName().contains(".bam-summary")) {
                primaryInterpretation.summaryDatas.add(data);
                continue;
            }
            if (!data.isContentTypeCompatitible("application/octet-stream") || !this.isIndexData(data)) continue;
            if (primaryInterpretation.indexData != null) {
                return null;
            }
            primaryInterpretation.indexData = data;
        }
        for (Interpretation interpretation : interpretations) {
            if (!interpretation.primaryData.getName().endsWith(".bam") || interpretation.indexData != null) continue;
            return null;
        }
        return interpretations;
    }

    @Override
    public boolean isForSingleData() {
        return true;
    }

    @Override
    public boolean isForMultipleDatas() {
        return true;
    }

    private void updateLocation() {
        boolean isSearch = false;
        if (!this.locationField.getText().isEmpty() && !GeneIndexActions.checkIfNumber(this.locationField.getText())) {
            this.requestGeneSearch();
            isSearch = true;
        }
        if (this.locationField.getText().trim().isEmpty() || isSearch) {
            this.setCoordinateFields(1000000L, null);
        }
        if (this.viewsizeField.getText().trim().isEmpty()) {
            this.setCoordinateFields(null, 100000L);
            this.lastViewsize = 100000L;
        }
        this.plot.moveDataBpRegion((Chromosome)this.chrBox.getSelectedItem(), Long.parseLong(this.locationField.getText()), this.lastViewsize);
        this.plot.setReadScale((GenomePlot.ReadScale)((Object)this.coverageScaleBox.getSelectedItem()));
    }

    private void setCoordinateFields(Long location, Long viewsize) {
        if (location != null) {
            this.locationField.setText(location.toString());
        }
        if (viewsize != null) {
            if (viewsize > 1000000L) {
                this.viewsizeField.setText(Math.round((float)viewsize.longValue() / 1000000.0f) + " Mb");
            } else if (viewsize > 1000L) {
                this.viewsizeField.setText(Math.round((float)viewsize.longValue() / 1000.0f) + " kb");
            } else {
                this.viewsizeField.setText(viewsize + "");
            }
        }
    }

    private void requestGeneSearch() {
        this.application.runBlockingTask("searching gene", new Runnable(){

            @Override
            public void run() {
                int TIME_OUT = 30000;
                int INTERVAL = 100;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() < startTime + (long)TIME_OUT && !GenomeBrowser.this.geneSearchDone) {
                    try {
                        Thread.sleep(INTERVAL);
                    }
                    catch (InterruptedException e) {}
                }
                if (GenomeBrowser.this.geneSearchDone) {
                    GenomeBrowser.this.geneSearchDone = false;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GenomeBrowser.this.application.showDialog("Search failed", "Unexpected error happened in the search. Please inform the developers if the problem persists.", null, DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, null);
                        }
                    });
                }
            }
        });
        this.getGeneIndexActions().requestLocation(this.locationField.getText(), new GeneIndexActions.GeneLocationListener(){

            @Override
            public void geneLocation(Region geneLocation) {
                GenomeBrowser.this.geneSearchDone = true;
                if (geneLocation == null) {
                    GenomeBrowser.this.updateLocation();
                    GenomeBrowser.this.application.showDialog("Not found", "Gene was not found", null, DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, null);
                } else {
                    Chromosome resultChr = new Chromosome(geneLocation.start.chr);
                    GenomeBrowser.this.chrBox.setSelectedItem(resultChr);
                    if (GenomeBrowser.this.chrBox.getSelectedItem().equals(resultChr)) {
                        GenomeBrowser.this.setCoordinateFields((geneLocation.end.bp + geneLocation.start.bp) / 2L, (geneLocation.end.bp - geneLocation.start.bp) * 2L);
                        GenomeBrowser.this.updateLocation();
                    } else {
                        GenomeBrowser.this.application.showDialog("Different chromosome", "Searched gene was found from chromosome " + resultChr + " but there is no data for that chromosome", "" + geneLocation, DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
                    }
                }
            }
        });
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.updateLocation();
        this.plot.redraw();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event instanceof PointSelectionEvent) {
            IntegratedEntity sel = this.application.getSelectionManager().getSelectionManager(null).getPointSelection();
            if (sel.containsKey("chromosome") && sel.containsKey("start")) {
                this.chrBox.setSelectedItem(new Chromosome((String)sel.get("chromosome")));
                long start = Long.parseLong((String)sel.get("start"));
                long end = -1L;
                end = sel.containsKey("end") ? Long.parseLong((String)sel.get("end")) : start;
                this.setCoordinateFields((end + start) / 2L, (end - start) * 2L);
            }
            this.updateLocation();
        }
    }

    @Override
    public void removeVisualisation() {
        super.removeVisualisation();
        this.plotPanel.removeComponentListener(this);
        this.plotPanel.removeAll();
        if (this.plot != null) {
            this.plot.clean();
            this.plot = null;
        }
        if (this.tracks != null) {
            this.tracks.clear();
        }
        this.gia = null;
        this.application.removeClientEventListener(this);
    }

    public class ObjVariable
    extends Visualisation.Variable {
        public Object obj;

        public ObjVariable(Object obj) {
            super(null, null);
            this.obj = obj;
        }
    }

    private static class Track {
        Interpretation interpretation;
        JCheckBox checkBox;
        String name;
        TrackGroup trackGroup = null;

        public Track(String name, Interpretation interpretation) {
            this.name = name;
            this.interpretation = interpretation;
        }

        public void setTrackGroup(TrackGroup trackGroup) {
            this.trackGroup = trackGroup;
        }
    }

    private static enum TrackType {
        CYTOBANDS(false),
        GENES(false),
        TRANSCRIPTS(true),
        REFERENCE(true),
        REGIONS(true),
        REGIONS_WITH_HEADER(true),
        READS(true),
        HIDDEN(false),
        VCF(true);

        private boolean isToggleable;

        private TrackType(boolean toggleable) {
            this.isToggleable = toggleable;
        }
    }

    private static class Interpretation {
        public TrackType type;
        public List<DataBean> summaryDatas = new LinkedList<DataBean>();
        public DataBean primaryData;
        public DataBean indexData;

        public Interpretation(TrackType type, DataBean primaryData) {
            this.type = type;
            this.primaryData = primaryData;
        }
    }
}

