/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.testng.log4testng.Logger;

public abstract class VisualisationFrame
implements DataChangeListener {
    private static final Color BG = Color.white;
    protected ClientApplication application = Session.getSession().getApplication();
    private static final String WAIT_PANEL_NAME = "wait";
    private static final String VISUALISATION_PANEL_NAME = "visualisation";
    private CardLayout viewChangerLayout = new CardLayout();
    private JPanel viewChangerPanel = new JPanel(this.viewChangerLayout);
    private JSplitPane paramSplit;
    private VisualisationMethod method;
    private List<Visualisation.Variable> variables;
    private List<DataBean> datas;
    protected VisualisationFrameManager.FrameType type;
    private Visualisation visualiser;
    private JPanel waitPanel;
    private static final Logger logger = Logger.getLogger(VisualisationFrame.class);

    public abstract void setContent(JComponent var1);

    public VisualisationFrame(VisualisationFrameManager.FrameType type) {
        this.type = type;
        this.viewChangerPanel.setBackground(BG);
        this.waitPanel = new JPanel(new BorderLayout());
        JLabel waitLabel = new JLabel("Visualising, please wait...");
        waitLabel.setFont(waitLabel.getFont().deriveFont(1));
        waitLabel.setHorizontalAlignment(0);
        this.waitPanel.add((Component)waitLabel, "Center");
        this.viewChangerPanel.add((Component)this.waitPanel, WAIT_PANEL_NAME);
        try {
            this.showVisualisationComponent(VisualisationMethod.NONE.getVisualiser(this).getVisualisation(new ArrayList<DataBean>()));
        }
        catch (Exception e) {
            this.application.reportException(e);
        }
        this.setContent(this.viewChangerPanel);
        this.viewChangerLayout.show(this.viewChangerPanel, VISUALISATION_PANEL_NAME);
        this.application.getDataManager().addDataChangeListener(this);
    }

    public JComponent createVisualisation(VisualisationMethodChangedEvent e) {
        if (this.datas != e.getDatas() || this.method != e.getNewMethod()) {
            this.datas = e.getDatas();
            this.method = e.getNewMethod();
            this.removeVisualiser();
            this.visualiser = this.method.getVisualiser(this);
        }
        this.variables = e.getVariables();
        JPanel parametersPanel = this.visualiser.getParameterPanel();
        logger.debug((Object)("parametersPanel for method " + this.method + " contains: " + parametersPanel));
        if (parametersPanel != null) {
            this.paramSplit = new JSplitPane();
            parametersPanel.setMinimumSize(new Dimension(0, 0));
            this.paramSplit.setRightComponent(parametersPanel);
            this.paramSplit.setContinuousLayout(true);
            this.paramSplit.setResizeWeight(1.0);
            SplitSizeHandler sizeHandler = new SplitSizeHandler();
            this.paramSplit.addPropertyChangeListener("dividerLocation", sizeHandler);
        } else if (this.paramSplit != null) {
            this.paramSplit.removeAll();
        }
        JComponent visualisationComponent = null;
        JComponent componentToReturn = null;
        try {
            if (this.visualiser.isForMultipleDatas()) {
                visualisationComponent = this.visualiser.getVisualisation(this.datas);
            } else if (this.visualiser.isForSingleData()) {
                DataBean data = this.datas.size() > 0 ? this.datas.get(0) : null;
                visualisationComponent = this.visualiser.getVisualisation(data);
            }
            if (parametersPanel != null) {
                this.paramSplit.setLeftComponent(visualisationComponent);
                componentToReturn = this.paramSplit;
            } else {
                componentToReturn = visualisationComponent;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"visualisationpanel contains following components:");
                for (Component component : this.paramSplit.getComponents()) {
                    logger.debug((Object)("\t" + component));
                }
            }
        }
        catch (Exception e1) {
            this.application.reportException(e1);
            componentToReturn = this.visualiser.getDefaultVisualisation();
        }
        return componentToReturn;
    }

    public void showVisualisationComponent(JComponent panel) {
        this.removeVisualisationComponent();
        if (panel == null) {
            try {
                panel = VisualisationMethod.NONE.getVisualiser(this).getVisualisation(new ArrayList<DataBean>());
            }
            catch (Exception e) {
                this.application.reportException(e);
            }
        }
        String title = "Visualisation";
        if (this.datas != null && this.datas.size() > 0) {
            title = title + " of ";
            for (int i = 0; i < this.datas.size(); ++i) {
                title = title + this.datas.get(i);
                if (i == this.datas.size() - 1) continue;
                title = title + (i == this.datas.size() - 2 ? " and " : ", ");
            }
        }
        this.setTitle(title);
        this.viewChangerPanel.add((Component)panel, VISUALISATION_PANEL_NAME);
        this.viewChangerLayout.show(this.viewChangerPanel, VISUALISATION_PANEL_NAME);
        if (this.paramSplit != null) {
            this.paramSplit.setDividerLocation(0.5);
        }
    }

    public void showWaitPanel() {
        this.removeVisualisationComponent();
        this.viewChangerLayout.show(this.viewChangerPanel, WAIT_PANEL_NAME);
    }

    public void removeVisualisationComponent() {
        for (Component component : this.viewChangerPanel.getComponents()) {
            if (component == this.waitPanel) continue;
            this.viewChangerPanel.remove(component);
            this.viewChangerLayout.removeLayoutComponent(component);
        }
    }

    private void removeVisualiser() {
        if (this.visualiser instanceof PropertyChangeListener) {
            this.application.removeClientEventListener((PropertyChangeListener)((Object)this.visualiser));
        }
        if (this.visualiser != null) {
            this.visualiser.removeVisualisation();
        }
    }

    public VisualisationMethod getVisualisationMethod() {
        return this.method;
    }

    public List<Visualisation.Variable> getVariables() {
        return this.variables;
    }

    public List<DataBean> getDatas() {
        return this.datas;
    }

    public VisualisationFrameManager.FrameType getType() {
        return this.type;
    }

    public VisualisationMethod getMethod() {
        return this.method;
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        if (e instanceof DataItemRemovedEvent) {
            if (this.datas != null && this.datas.contains(((DataItemRemovedEvent)e).getDataItem())) {
                this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.NONE, null, null, this.type, this));
            }
            if (this.method == null || this.method == VisualisationMethod.NONE) {
                this.updateContextLinks();
            }
        } else if (e instanceof DataItemCreatedEvent && (this.method == null || this.method == VisualisationMethod.NONE)) {
            this.updateContextLinks();
        }
    }

    protected abstract void updateContextLinks();

    void setTitle(String title) {
    }

    private class SplitSizeHandler
    implements PropertyChangeListener {
        private SplitSizeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            int leftLimit = VisualisationFrame.this.paramSplit.getWidth() - (int)Visualisation.PARAMETER_SIZE.getWidth();
            if (VisualisationFrame.this.paramSplit.getDividerLocation() < leftLimit) {
                VisualisationFrame.this.paramSplit.setDividerLocation(leftLimit);
            }
        }
    }
}

