/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.ImportParameterPanel;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TaskImportDialog
extends JDialog
implements ActionListener {
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private static final String DEFAULT_NOTE_TEXT = "It may take a while for the import task to finish.";
    private JLabel titleLabel;
    private JLabel descriptionLabel;
    private JLabel noteLabel;
    private JButton okButton;
    private JButton skipButton;
    private JButton cancelButton;
    private JComboBox folderNameCombo;
    private ClientApplication application;
    private ImportSession importSession;
    private Operation importOperation;

    public TaskImportDialog(ClientApplication application, String title, ImportSession importSession, Operation importOperation) throws MicroarrayException {
        this(application, title, importSession, importOperation, "Import", "Cancel", "Skip");
    }

    public TaskImportDialog(ClientApplication application, String title, ImportSession importSession, Operation importOperation, String okButtonText, String cancelButtonText, String skipButtonText) throws MicroarrayException {
        this(application, title, importSession, importOperation, okButtonText, cancelButtonText, skipButtonText, DEFAULT_NOTE_TEXT);
    }

    public TaskImportDialog(ClientApplication application, String title, ImportSession importSession, Operation importOperation, String okButtonText, String cancelButtonText, String skipButtonText, String noteText) throws MicroarrayException {
        super((Frame)Session.getSession().getFrames().getMainFrame(), true);
        this.application = application;
        this.importSession = importSession;
        this.importOperation = importOperation;
        this.setTitle("Import");
        this.setModal(true);
        this.setPreferredSize(new Dimension(500, 300));
        this.titleLabel = new JLabel("<html><p style=\"font-weight:bold;font-size:115%\">" + title + "</p></html>");
        this.descriptionLabel = new JLabel("<html>" + importOperation.getDescription() + "</html>");
        this.noteLabel = new JLabel("<html><p style=\"font-style:italic\">" + noteText + "</p></html>");
        this.folderNameCombo = new JComboBox<Object>(ImportUtils.getFolderNames(false).toArray());
        this.folderNameCombo.setEditable(true);
        this.okButton = new JButton(okButtonText);
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.skipButton = new JButton(skipButtonText);
        this.skipButton.setPreferredSize(this.BUTTON_SIZE);
        this.skipButton.addActionListener(this);
        this.cancelButton = new JButton(cancelButtonText);
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        ImportParameterPanel parameterPanel = new ImportParameterPanel(importOperation, null);
        JPanel keepButtonsRightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.weightx = 1.0;
        buttonConstraints.weighty = 1.0;
        buttonConstraints.anchor = 13;
        buttonConstraints.insets.set(0, 0, 0, 8);
        keepButtonsRightPanel.add((Component)this.cancelButton, buttonConstraints);
        if (importSession != null) {
            buttonConstraints.anchor = 10;
            keepButtonsRightPanel.add((Component)this.skipButton, buttonConstraints);
        }
        buttonConstraints.gridx = -1;
        buttonConstraints.insets.set(0, 0, 0, 0);
        keepButtonsRightPanel.add((Component)this.okButton, buttonConstraints);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets.set(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.titleLabel, c);
        ++c.gridy;
        this.add((Component)this.descriptionLabel, c);
        ++c.gridy;
        c.weighty = 120.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets.set(0, 10, 10, 10);
        this.add((Component)parameterPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets.set(0, 10, 10, 10);
        c.fill = 2;
        this.add((Component)this.noteLabel, c);
        c.insets.set(10, 10, 10, 10);
        c.anchor = 14;
        ++c.gridy;
        c.fill = 0;
        this.add((Component)keepButtonsRightPanel, c);
        this.pack();
        Session.getSession().getFrames().setLocationRelativeToMainFrame(this);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                this.application.executeOperation(this.importOperation);
            }
            catch (Exception me) {
                this.application.reportException(me);
            }
            finally {
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.skipButton) {
            this.application.importGroup(this.importSession.getImportItems(), this.importSession.getDestinationFolder());
            this.dispose();
        }
    }
}

