/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.table;

import fi.csc.microarray.client.dataimport.ImportScreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class PanelTableHeaderRenderer
extends JPanel
implements TableCellRenderer,
ItemListener {
    private JComboBox chipCombo;
    private JLabel titleLabel;
    private JLabel typeLabel;
    private ImportScreen screen;
    private int columnIndex;

    public PanelTableHeaderRenderer(ImportScreen screen, int i) {
        this.screen = screen;
        this.columnIndex = i;
        this.chipCombo = new JComboBox();
        this.titleLabel = new JLabel("Title");
        this.typeLabel = new JLabel("Type");
        this.chipCombo.addItemListener(this);
        this.setLayout(new BorderLayout());
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        border.getBorderInsets(this).set(5, 5, 5, 5);
        this.setBorder(border);
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.typeLabel, "West");
        this.add((Component)this.chipCombo, "East");
    }

    public void setSelectedIndex(int index) {
        if (this.chipCombo.getModel().getSize() > index && index >= 0) {
            this.chipCombo.setSelectedIndex(index);
        }
    }

    public int getSelectedIndex() {
        return this.chipCombo.getSelectedIndex();
    }

    public JComboBox getCombo() {
        return this.chipCombo;
    }

    public void setTitleText(String text) {
        this.titleLabel.setText(text);
        this.update();
    }

    public void setTypeText(String text) {
        this.typeLabel.setText("<html><b>" + text + "</b></html>");
        this.update();
    }

    public void setTypeColor(Color c) {
        this.typeLabel.setForeground(c);
        this.update();
    }

    public void update() {
        this.screen.getTableFrame().getTable().getTableHeader().repaint();
    }

    public void setTypeToolTipText(String text) {
        this.typeLabel.setToolTipText(text);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Integer) {
            this.setSelectedIndex((Integer)value);
        }
        return this;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Integer newValue;
        if (e.getSource() instanceof JComboBox && (newValue = (Integer)e.getItem()).intValue() != this.screen.getColumnTypeManager().getColumnChipNumber(this.columnIndex)) {
            this.screen.getColumnTypeManager().setColumnChipNumber(this.columnIndex, newValue);
        }
    }
}

