/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.AdminAPI;
import fi.csc.microarray.messaging.DescriptionMessageListener;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.SourceMessageListener;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.FeedbackMessage;
import fi.csc.microarray.module.Module;
import java.util.Collection;
import javax.jms.JMSException;

public class RemoteServiceAccessor
implements ServiceAccessor {
    protected MessagingEndpoint endpoint;
    protected MessagingTopic requestTopic;
    protected TaskExecutor taskExecutor;
    private FileBrokerClient filebrokerClient;
    private NodeBase nodeSupport = new NodeBase(){

        @Override
        public String getName() {
            return "client";
        }
    };
    private Collection<ToolModule> modules = null;

    @Override
    public void initialise(DataManager manager, AuthenticationRequestListener authenticationRequestListener) throws MicroarrayException, JMSException {
        this.endpoint = new MessagingEndpoint(this.nodeSupport, authenticationRequestListener);
        this.requestTopic = this.endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.taskExecutor = new TaskExecutor(this.endpoint, manager);
        this.filebrokerClient = new JMSFileBrokerClient(this.endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE));
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        if (this.taskExecutor == null) {
            throw new IllegalStateException("initialise(...) must be called first");
        }
        return this.taskExecutor;
    }

    @Override
    public String checkRemoteServices() throws Exception {
        AdminAPI api = new AdminAPI(this.endpoint.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE), null);
        if (api.areAllServicesUp(true)) {
            return "ok";
        }
        return "required services are not available (" + api.getErrorStatus() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchDescriptions(Module module) throws Exception {
        DescriptionMessageListener descriptionListener = new DescriptionMessageListener(module.getServerModuleNames());
        try {
            this.requestTopic.sendReplyableMessage(new CommandMessage("describe"), descriptionListener);
            descriptionListener.waitForResponse();
        }
        finally {
            descriptionListener.cleanUp();
        }
        this.modules = descriptionListener.getModules();
    }

    @Override
    public Collection<ToolModule> getModules() {
        if (this.modules == null) {
            throw new IllegalStateException("fetchDescriptions(...) must be called first");
        }
        return this.modules;
    }

    @Override
    public void close() throws Exception {
        this.endpoint.close();
    }

    @Override
    public SourceMessageListener retrieveSourceCode(String id) throws Exception {
        SourceMessageListener sourceListener = new SourceMessageListener();
        CommandMessage commandMessage = new CommandMessage("get-source");
        commandMessage.addParameter(id);
        this.requestTopic.sendReplyableMessage(commandMessage, sourceListener);
        return sourceListener;
    }

    @Override
    public FileBrokerClient getFileBrokerClient() throws Exception {
        return this.filebrokerClient;
    }

    @Override
    public void sendFeedbackMessage(FeedbackMessage message) throws Exception {
        MessagingTopic requestTopic = this.endpoint.createTopic(Topics.Name.FEEDBACK_TOPIC, MessagingTopic.AccessMode.WRITE);
        requestTopic.sendMessage(message);
    }

    @Override
    public boolean isStandalone() {
        return false;
    }
}

