/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.validation.support.BindingAwareModelMap;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.annotation.support.HandlerMethodInvoker;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;
import org.springframework.web.servlet.mvc.annotation.ServletAnnotationMappingUtils;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMethodHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter,
Ordered,
BeanFactoryAware {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private int cacheSecondsForSessionAttributeHandlers = 0;
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private WebArgumentResolver[] customArgumentResolvers;
    private ModelAndViewResolver[] customModelAndViewResolvers;
    private HttpMessageConverter<?>[] messageConverters = new HttpMessageConverter[]{new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(), new SourceHttpMessageConverter(), new XmlAwareFormHttpMessageConverter()};
    private int order = Integer.MAX_VALUE;
    private ConfigurableBeanFactory beanFactory;
    private BeanExpressionContext expressionContext;
    private final Map<Class<?>, ServletHandlerMethodResolver> methodResolverCache = new ConcurrentHashMap();

    public AnnotationMethodHandlerAdapter() {
        super(false);
    }

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setCacheSecondsForSessionAttributeHandlers(int cacheSecondsForSessionAttributeHandlers) {
        this.cacheSecondsForSessionAttributeHandlers = cacheSecondsForSessionAttributeHandlers;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setCustomModelAndViewResolver(ModelAndViewResolver customModelAndViewResolver) {
        this.customModelAndViewResolvers = new ModelAndViewResolver[]{customModelAndViewResolver};
    }

    public void setCustomModelAndViewResolvers(ModelAndViewResolver[] customModelAndViewResolvers) {
        this.customModelAndViewResolvers = customModelAndViewResolvers;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public HttpMessageConverter<?>[] getMessageConverters() {
        return this.messageConverters;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
            this.expressionContext = new BeanExpressionContext(this.beanFactory, (Scope)new RequestScope());
        }
    }

    @Override
    public boolean supports(Object handler) {
        return this.getMethodResolver(handler).hasHandlerMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HttpSession session;
        if (AnnotationUtils.findAnnotation(handler.getClass(), SessionAttributes.class) != null) {
            this.checkAndPrepare(request, response, this.cacheSecondsForSessionAttributeHandlers, true);
        } else {
            this.checkAndPrepare(request, response, true);
        }
        if (this.synchronizeOnSession && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return this.invokeHandlerMethod(request, response, handler);
            }
        }
        return this.invokeHandlerMethod(request, response, handler);
    }

    protected ModelAndView invokeHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ServletHandlerMethodResolver methodResolver = this.getMethodResolver(handler);
        Method handlerMethod = methodResolver.resolveHandlerMethod(request);
        ServletHandlerMethodInvoker methodInvoker = new ServletHandlerMethodInvoker(methodResolver);
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        BindingAwareModelMap implicitModel = new BindingAwareModelMap();
        Object result = methodInvoker.invokeHandlerMethod(handlerMethod, handler, (NativeWebRequest)webRequest, (ExtendedModelMap)implicitModel);
        ModelAndView mav = methodInvoker.getModelAndView(handlerMethod, handler.getClass(), result, (ExtendedModelMap)implicitModel, webRequest);
        methodInvoker.updateModelAttributes(handler, mav != null ? mav.getModel() : null, (ExtendedModelMap)implicitModel, (NativeWebRequest)webRequest);
        return mav;
    }

    @Override
    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    private ServletHandlerMethodResolver getMethodResolver(Object handler) {
        Class handlerClass = ClassUtils.getUserClass((Object)handler);
        ServletHandlerMethodResolver resolver = this.methodResolverCache.get(handlerClass);
        if (resolver == null) {
            resolver = new ServletHandlerMethodResolver(handlerClass);
            this.methodResolverCache.put(handlerClass, resolver);
        }
        return resolver;
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object target, String objectName) throws Exception {
        return new ServletRequestDataBinder(target, objectName);
    }

    protected HttpInputMessage createHttpInputMessage(HttpServletRequest servletRequest) throws Exception {
        return new ServletServerHttpRequest(servletRequest);
    }

    protected HttpOutputMessage createHttpOutputMessage(HttpServletResponse servletResponse) throws Exception {
        return new ServletServerHttpResponse(servletResponse);
    }

    static class RequestMappingInfo {
        String[] paths = new String[0];
        List<String> matchedPaths = Collections.emptyList();
        RequestMethod[] methods = new RequestMethod[0];
        String[] params = new String[0];
        String[] headers = new String[0];

        RequestMappingInfo() {
        }

        public String bestMatchedPath() {
            return !this.matchedPaths.isEmpty() ? this.matchedPaths.get(0) : null;
        }

        public boolean matches(HttpServletRequest request) {
            return ServletAnnotationMappingUtils.checkRequestMethod(this.methods, request) && ServletAnnotationMappingUtils.checkParameters(this.params, request) && ServletAnnotationMappingUtils.checkHeaders(this.headers, request);
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return Arrays.equals(this.paths, other.paths) && Arrays.equals(this.methods, other.methods) && Arrays.equals(this.params, other.params) && Arrays.equals(this.headers, other.headers);
        }

        public int hashCode() {
            return Arrays.hashCode(this.paths) * 23 + Arrays.hashCode(this.methods) * 29 + Arrays.hashCode(this.params) * 31 + Arrays.hashCode(this.headers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestMappingInfoComparator
    implements Comparator<RequestMappingInfo> {
        private final Comparator<String> pathComparator;
        private final ServerHttpRequest request;

        RequestMappingInfoComparator(Comparator<String> pathComparator, HttpServletRequest request) {
            this.pathComparator = pathComparator;
            this.request = new ServletServerHttpRequest(request);
        }

        @Override
        public int compare(RequestMappingInfo info1, RequestMappingInfo info2) {
            int pathComparison = this.pathComparator.compare(info1.bestMatchedPath(), info2.bestMatchedPath());
            if (pathComparison != 0) {
                return pathComparison;
            }
            int info1ParamCount = info1.params.length;
            int info2ParamCount = info2.params.length;
            if (info1ParamCount != info2ParamCount) {
                return info2ParamCount - info1ParamCount;
            }
            int info1HeaderCount = info1.headers.length;
            int info2HeaderCount = info2.headers.length;
            if (info1HeaderCount != info2HeaderCount) {
                return info2HeaderCount - info1HeaderCount;
            }
            int acceptComparison = this.compareAcceptHeaders(info1, info2);
            if (acceptComparison != 0) {
                return acceptComparison;
            }
            int info1MethodCount = info1.methods.length;
            int info2MethodCount = info2.methods.length;
            if (info1MethodCount == 0 && info2MethodCount > 0) {
                return 1;
            }
            if (info2MethodCount == 0 && info1MethodCount > 0) {
                return -1;
            }
            if (info1MethodCount == 1 & info2MethodCount > 1) {
                return -1;
            }
            if (info2MethodCount == 1 & info1MethodCount > 1) {
                return 1;
            }
            return 0;
        }

        private int compareAcceptHeaders(RequestMappingInfo info1, RequestMappingInfo info2) {
            List requestAccepts = this.request.getHeaders().getAccept();
            MediaType.sortByQualityValue((List)requestAccepts);
            List<MediaType> info1Accepts = this.getAcceptHeaderValue(info1);
            List<MediaType> info2Accepts = this.getAcceptHeaderValue(info2);
            for (MediaType requestAccept : requestAccepts) {
                int pos2;
                int pos1 = this.indexOfIncluded(info1Accepts, requestAccept);
                if (pos1 == (pos2 = this.indexOfIncluded(info2Accepts, requestAccept))) continue;
                return pos2 - pos1;
            }
            return 0;
        }

        private int indexOfIncluded(List<MediaType> infoAccepts, MediaType requestAccept) {
            int i = 0;
            while (i < infoAccepts.size()) {
                MediaType info1Accept = infoAccepts.get(i);
                if (requestAccept.includes(info1Accept)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private List<MediaType> getAcceptHeaderValue(RequestMappingInfo info) {
            String[] stringArray = info.headers;
            int n = info.headers.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                int separator = header.indexOf(61);
                if (separator != -1) {
                    String key = header.substring(0, separator);
                    String value = header.substring(separator + 1);
                    if ("Accept".equalsIgnoreCase(key)) {
                        return MediaType.parseMediaTypes((String)value);
                    }
                }
                ++n2;
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServletHandlerMethodInvoker
    extends HandlerMethodInvoker {
        private boolean responseArgumentUsed;

        private ServletHandlerMethodInvoker(HandlerMethodResolver resolver) {
            super(resolver, AnnotationMethodHandlerAdapter.this.webBindingInitializer, AnnotationMethodHandlerAdapter.this.sessionAttributeStore, AnnotationMethodHandlerAdapter.this.parameterNameDiscoverer, AnnotationMethodHandlerAdapter.this.customArgumentResolvers, AnnotationMethodHandlerAdapter.this.messageConverters);
            this.responseArgumentUsed = false;
        }

        protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
            throw new MissingServletRequestParameterException(paramName, paramType.getSimpleName());
        }

        protected void raiseSessionRequiredException(String message) throws Exception {
            throw new HttpSessionRequiredException(message);
        }

        protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return AnnotationMethodHandlerAdapter.this.createBinder((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class), target, objectName);
        }

        protected void doBind(WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
            ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
            servletBinder.bind((ServletRequest)webRequest.getNativeRequest(ServletRequest.class));
        }

        protected HttpInputMessage createHttpInputMessage(NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            return AnnotationMethodHandlerAdapter.this.createHttpInputMessage(servletRequest);
        }

        protected HttpOutputMessage createHttpOutputMessage(NativeWebRequest webRequest) throws Exception {
            HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse();
            return AnnotationMethodHandlerAdapter.this.createHttpOutputMessage(servletResponse);
        }

        protected Object resolveDefaultValue(String value) {
            if (AnnotationMethodHandlerAdapter.this.beanFactory == null) {
                return value;
            }
            String placeholdersResolved = AnnotationMethodHandlerAdapter.this.beanFactory.resolveEmbeddedValue(value);
            BeanExpressionResolver exprResolver = AnnotationMethodHandlerAdapter.this.beanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return value;
            }
            return exprResolver.evaluate(placeholdersResolved, AnnotationMethodHandlerAdapter.this.expressionContext);
        }

        protected Object resolveCookieValue(String cookieName, Class paramType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Cookie cookieValue = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)cookieName);
            if (Cookie.class.isAssignableFrom(paramType)) {
                return cookieValue;
            }
            if (cookieValue != null) {
                return cookieValue.getValue();
            }
            return null;
        }

        protected String resolvePathVariable(String pathVarName, Class paramType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Map uriTemplateVariables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (uriTemplateVariables == null || !uriTemplateVariables.containsKey(pathVarName)) {
                throw new IllegalStateException("Could not find @PathVariable [" + pathVarName + "] in @RequestMapping");
            }
            return (String)uriTemplateVariables.get(pathVarName);
        }

        protected Object resolveStandardArgument(Class parameterType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            if (ServletRequest.class.isAssignableFrom(parameterType)) {
                return request;
            }
            if (ServletResponse.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response;
            }
            if (HttpSession.class.isAssignableFrom(parameterType)) {
                return request.getSession();
            }
            if (Principal.class.isAssignableFrom(parameterType)) {
                return request.getUserPrincipal();
            }
            if (Locale.class.equals((Object)parameterType)) {
                return RequestContextUtils.getLocale(request);
            }
            if (InputStream.class.isAssignableFrom(parameterType)) {
                return request.getInputStream();
            }
            if (Reader.class.isAssignableFrom(parameterType)) {
                return request.getReader();
            }
            if (OutputStream.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getOutputStream();
            }
            if (Writer.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getWriter();
            }
            return super.resolveStandardArgument(parameterType, webRequest);
        }

        public ModelAndView getModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel, ServletWebRequest webRequest) throws Exception {
            ResponseStatus responseStatusAnn = (ResponseStatus)AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseStatus.class);
            if (responseStatusAnn != null) {
                HttpStatus responseStatus = responseStatusAnn.value();
                String reason = responseStatusAnn.reason();
                if (!StringUtils.hasText((String)reason)) {
                    webRequest.getResponse().setStatus(responseStatus.value());
                } else {
                    webRequest.getResponse().sendError(responseStatus.value(), reason);
                }
                webRequest.getRequest().setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)responseStatus);
                this.responseArgumentUsed = true;
            }
            if (AnnotationMethodHandlerAdapter.this.customModelAndViewResolvers != null) {
                ModelAndViewResolver[] modelAndViewResolverArray = AnnotationMethodHandlerAdapter.this.customModelAndViewResolvers;
                int n = modelAndViewResolverArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelAndViewResolver mavResolver = modelAndViewResolverArray[n2];
                    ModelAndView mav = mavResolver.resolveModelAndView(handlerMethod, handlerType, returnValue, implicitModel, (NativeWebRequest)webRequest);
                    if (mav != ModelAndViewResolver.UNRESOLVED) {
                        return mav;
                    }
                    ++n2;
                }
            }
            if (returnValue instanceof HttpEntity) {
                this.handleHttpEntityResponse((HttpEntity)returnValue, webRequest);
                return null;
            }
            if (AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseBody.class) != null) {
                this.handleResponseBody(returnValue, webRequest);
                return null;
            }
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Model) {
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel).addAllObjects(((Model)returnValue).asMap());
            }
            if (returnValue instanceof View) {
                return new ModelAndView((View)returnValue).addAllObjects((Map<String, ?>)implicitModel);
            }
            if (AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class) != null) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map<String, ?>)implicitModel);
            }
            if (returnValue == null) {
                if (this.responseArgumentUsed || webRequest.isNotModified()) {
                    return null;
                }
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }

        private void handleResponseBody(Object returnValue, ServletWebRequest webRequest) throws Exception {
            if (returnValue == null) {
                return;
            }
            HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
            this.writeWithMessageConverters(returnValue, inputMessage, outputMessage);
        }

        private void handleHttpEntityResponse(HttpEntity<?> responseEntity, ServletWebRequest webRequest) throws Exception {
            Object body;
            HttpHeaders entityHeaders;
            if (responseEntity == null) {
                return;
            }
            HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
            if (responseEntity instanceof ResponseEntity && outputMessage instanceof ServerHttpResponse) {
                ((ServerHttpResponse)outputMessage).setStatusCode(((ResponseEntity)responseEntity).getStatusCode());
            }
            if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
                outputMessage.getHeaders().putAll((Map)entityHeaders);
            }
            if ((body = responseEntity.getBody()) != null) {
                this.writeWithMessageConverters(body, inputMessage, outputMessage);
            }
        }

        private void writeWithMessageConverters(Object returnValue, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
            List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            }
            MediaType.sortByQualityValue((List)acceptedMediaTypes);
            Class<?> returnValueType = returnValue.getClass();
            ArrayList allSupportedMediaTypes = new ArrayList();
            if (AnnotationMethodHandlerAdapter.this.getMessageConverters() != null) {
                for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    HttpMessageConverter<?>[] httpMessageConverterArray = AnnotationMethodHandlerAdapter.this.getMessageConverters();
                    int n = httpMessageConverterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HttpMessageConverter<?> messageConverter = httpMessageConverterArray[n2];
                        if (messageConverter.canWrite(returnValueType, acceptedMediaType)) {
                            messageConverter.write(returnValue, acceptedMediaType, outputMessage);
                            if (((ApplicationObjectSupport)AnnotationMethodHandlerAdapter.this).logger.isDebugEnabled()) {
                                MediaType contentType = outputMessage.getHeaders().getContentType();
                                if (contentType == null) {
                                    contentType = acceptedMediaType;
                                }
                                ((ApplicationObjectSupport)AnnotationMethodHandlerAdapter.this).logger.debug((Object)("Written [" + returnValue + "] as \"" + contentType + "\" using [" + messageConverter + "]"));
                            }
                            this.responseArgumentUsed = true;
                            return;
                        }
                        ++n2;
                    }
                }
                HttpMessageConverter[] httpMessageConverterArray = AnnotationMethodHandlerAdapter.this.messageConverters;
                int n = httpMessageConverterArray.length;
                int n3 = 0;
                while (n3 < n) {
                    HttpMessageConverter messageConverter = httpMessageConverterArray[n3];
                    allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
                    ++n3;
                }
            }
            throw new HttpMediaTypeNotAcceptableException(allSupportedMediaTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServletHandlerMethodResolver
    extends HandlerMethodResolver {
        private ServletHandlerMethodResolver(Class<?> handlerType) {
            this.init(handlerType);
        }

        public Method resolveHandlerMethod(HttpServletRequest request) throws ServletException {
            String lookupPath = AnnotationMethodHandlerAdapter.this.urlPathHelper.getLookupPathForRequest(request);
            Comparator pathComparator = AnnotationMethodHandlerAdapter.this.pathMatcher.getPatternComparator(lookupPath);
            LinkedHashMap<RequestMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestMappingInfo, Method>();
            LinkedHashSet<String> allowedMethods = new LinkedHashSet<String>(7);
            String resolvedMethodName = null;
            for (Method handlerMethod : this.getHandlerMethods()) {
                Method oldMappedMethod;
                int n;
                RequestMappingInfo mappingInfo = new RequestMappingInfo();
                RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)handlerMethod, RequestMapping.class);
                mappingInfo.paths = mapping.value();
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.method(), this.getTypeLevelMapping().method())) {
                    mappingInfo.methods = mapping.method();
                }
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.params(), this.getTypeLevelMapping().params())) {
                    mappingInfo.params = mapping.params();
                }
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.headers(), this.getTypeLevelMapping().headers())) {
                    mappingInfo.headers = mapping.headers();
                }
                boolean match = false;
                if (mappingInfo.paths.length > 0) {
                    ArrayList<String> matchedPaths = new ArrayList<String>(mappingInfo.paths.length);
                    String[] stringArray = mappingInfo.paths;
                    int n2 = mappingInfo.paths.length;
                    n = 0;
                    while (n < n2) {
                        String matchedPattern;
                        String mappedPattern = stringArray[n];
                        if (!this.hasTypeLevelMapping() && !mappedPattern.startsWith("/")) {
                            mappedPattern = "/" + mappedPattern;
                        }
                        if ((matchedPattern = this.getMatchedPattern(mappedPattern, lookupPath, request)) != null) {
                            if (!mappingInfo.matches(request)) {
                                RequestMethod[] requestMethodArray = mappingInfo.methods;
                                int n3 = mappingInfo.methods.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    RequestMethod requestMethod = requestMethodArray[n4];
                                    allowedMethods.add(requestMethod.toString());
                                    ++n4;
                                }
                                break;
                            }
                            match = true;
                            matchedPaths.add(matchedPattern);
                        }
                        ++n;
                    }
                    Collections.sort(matchedPaths, pathComparator);
                    mappingInfo.matchedPaths = matchedPaths;
                } else {
                    match = mappingInfo.matches(request);
                    if (match && mappingInfo.methods.length == 0 && mappingInfo.params.length == 0 && resolvedMethodName != null && !resolvedMethodName.equals(handlerMethod.getName())) {
                        match = false;
                    } else {
                        RequestMethod[] requestMethodArray = mappingInfo.methods;
                        n = mappingInfo.methods.length;
                        int n5 = 0;
                        while (n5 < n) {
                            RequestMethod requestMethod = requestMethodArray[n5];
                            allowedMethods.add(requestMethod.toString());
                            ++n5;
                        }
                    }
                }
                if (!match || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                if (AnnotationMethodHandlerAdapter.this.methodNameResolver != null && mappingInfo.paths.length == 0 && !oldMappedMethod.getName().equals(handlerMethod.getName())) {
                    if (resolvedMethodName == null) {
                        resolvedMethodName = AnnotationMethodHandlerAdapter.this.methodNameResolver.getHandlerMethodName(request);
                    }
                    if (!resolvedMethodName.equals(oldMappedMethod.getName())) {
                        oldMappedMethod = null;
                    }
                    if (!resolvedMethodName.equals(handlerMethod.getName())) {
                        if (oldMappedMethod != null) {
                            targetHandlerMethods.put(mappingInfo, oldMappedMethod);
                            oldMappedMethod = null;
                        } else {
                            targetHandlerMethods.remove(mappingInfo);
                        }
                    }
                }
                if (oldMappedMethod == null) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + lookupPath + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same path in multiple methods, then factor " + "them out into a dedicated handler class with that path mapped at the type level!");
            }
            if (!targetHandlerMethods.isEmpty()) {
                ArrayList matches = new ArrayList(targetHandlerMethods.keySet());
                RequestMappingInfoComparator requestMappingInfoComparator = new RequestMappingInfoComparator(pathComparator, request);
                Collections.sort(matches, requestMappingInfoComparator);
                RequestMappingInfo bestMappingMatch = (RequestMappingInfo)matches.get(0);
                String bestMatchedPath = bestMappingMatch.bestMatchedPath();
                if (bestMatchedPath != null) {
                    this.extractHandlerMethodUriTemplates(bestMatchedPath, lookupPath, request);
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            if (!allowedMethods.isEmpty()) {
                throw new HttpRequestMethodNotSupportedException(request.getMethod(), StringUtils.toStringArray(allowedMethods));
            }
            throw new NoSuchRequestHandlingMethodException(lookupPath, request.getMethod(), request.getParameterMap());
        }

        private String getMatchedPattern(String methodLevelPattern, String lookupPath, HttpServletRequest request) {
            String combinedPattern;
            if (this.hasTypeLevelMapping() && !ObjectUtils.isEmpty((Object[])this.getTypeLevelMapping().value())) {
                String[] typeLevelPatterns;
                String[] stringArray = typeLevelPatterns = this.getTypeLevelMapping().value();
                int n = typeLevelPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String combinedPattern2;
                    String typeLevelPattern = stringArray[n2];
                    if (!typeLevelPattern.startsWith("/")) {
                        typeLevelPattern = "/" + typeLevelPattern;
                    }
                    if (this.isPathMatchInternal(combinedPattern2 = AnnotationMethodHandlerAdapter.this.pathMatcher.combine(typeLevelPattern, methodLevelPattern), lookupPath)) {
                        return combinedPattern2;
                    }
                    ++n2;
                }
                return null;
            }
            String bestMatchingPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
            if (StringUtils.hasText((String)bestMatchingPattern) && bestMatchingPattern.endsWith("*") && !(combinedPattern = AnnotationMethodHandlerAdapter.this.pathMatcher.combine(bestMatchingPattern, methodLevelPattern)).equals(bestMatchingPattern) && this.isPathMatchInternal(combinedPattern, lookupPath)) {
                return combinedPattern;
            }
            if (this.isPathMatchInternal(methodLevelPattern, lookupPath)) {
                return methodLevelPattern;
            }
            return null;
        }

        private boolean isPathMatchInternal(String pattern, String lookupPath) {
            boolean hasSuffix;
            if (pattern.equals(lookupPath) || AnnotationMethodHandlerAdapter.this.pathMatcher.match(pattern, lookupPath)) {
                return true;
            }
            boolean bl = hasSuffix = pattern.indexOf(46) != -1;
            if (!hasSuffix && AnnotationMethodHandlerAdapter.this.pathMatcher.match(String.valueOf(pattern) + ".*", lookupPath)) {
                return true;
            }
            boolean endsWithSlash = pattern.endsWith("/");
            return !endsWithSlash && AnnotationMethodHandlerAdapter.this.pathMatcher.match(String.valueOf(pattern) + "/", lookupPath);
        }

        private void extractHandlerMethodUriTemplates(String mappedPattern, String lookupPath, HttpServletRequest request) {
            Map variables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            int patternVariableCount = StringUtils.countOccurrencesOf((String)mappedPattern, (String)"{");
            if ((variables == null || patternVariableCount != variables.size()) && AnnotationMethodHandlerAdapter.this.pathMatcher.match(mappedPattern, lookupPath)) {
                variables = AnnotationMethodHandlerAdapter.this.pathMatcher.extractUriTemplateVariables(mappedPattern, lookupPath);
                request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, (Object)variables);
            }
        }
    }
}

