/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricCollector;

public class AggregateMetricCollector<T extends MetricBase, R>
implements MetricCollector<T, R> {
    private final MetricCollector<T, R>[] collectors;

    public AggregateMetricCollector(MetricCollector<T, R> ... collectors) {
        if (collectors.length == 0) {
            throw new IllegalArgumentException("Must supply at least one collector.");
        }
        this.collectors = collectors;
    }

    @Override
    public void addRecord(R record) {
        for (MetricCollector<T, R> collector : this.collectors) {
            collector.addRecord(record);
        }
    }

    @Override
    public void onComplete() {
        for (MetricCollector<T, R> collector : this.collectors) {
            collector.onComplete();
        }
    }

    @Override
    public void setMetrics(T metrics) {
        for (MetricCollector<T, R> collector : this.collectors) {
            collector.setMetrics(metrics);
        }
    }

    @Override
    public T getMetrics() {
        return this.collectors[0].getMetrics();
    }
}

