/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="json")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=false)
    private Boolean prettyPrint;
    @XmlAttribute(required=false)
    private JsonLibrary library = JsonLibrary.XStream;
    @XmlAttribute(required=false)
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;

    public JsonDataFormat() {
    }

    public JsonDataFormat(JsonLibrary library) {
        this.library = library;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.library == JsonLibrary.XStream) {
            this.setProperty(this, "dataFormatName", "json-xstream");
        } else {
            this.setProperty(this, "dataFormatName", "json-jackson");
        }
        if (this.unmarshalType == null && this.unmarshalTypeName != null) {
            try {
                this.unmarshalType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshalTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.unmarshalType != null) {
            this.setProperty(dataFormat, "unmarshalType", this.unmarshalType);
        }
    }
}

